using System.Text.Json;

using TrackerDeFavorisApi.Models;
using TrackerDeFavorisApi.Models.Omdb;

namespace TrackerDeFavorisApi.Services;

public class OmdbService
{
    private readonly string? apiKey;

    public OmdbService(IConfiguration configuration)
    {
        apiKey = configuration["APIKey"];
    }

    public async Task<List<Film>?> SearchByTitle(string title)
    {//async Task<List<Film>>
        HttpClient client = new HttpClient();
        try
        {
            HttpResponseMessage response = await client.GetAsync($"https://www.omdbapi.com/?s={title}&page=1&type=movie&apikey={apiKey}");
            
            try
            {
                string? str = await response.Content.ReadAsStringAsync();
                OmdbSearchResponse? robert = JsonSerializer.Deserialize<OmdbSearchResponse>(str);
                if (robert == null)
                {
                    throw new InvalidOperationException("La réponse de l'API OMDB est nulle ou invalide!!!!!!");
                }
                List<Film>? result = robert.OmdbFilms!.Select(of => new Film(of.Title,of.ImdbId,of.Poster,null,null,null,null)).ToList();
                return result;

            }
            catch(InvalidOperationException)
            {
                Console.WriteLine("La réponse de l'API OMDB est nulle ou invalide!!!!!!");
                return null;
            }
            
        }
        catch(HttpRequestException e)
        {
            Console.WriteLine($"La requête à OMDB a échoué avec le code d'état HTTP : {e.Message}");
            return null;
        }        
    }
    public async Task<Film?> GetByImbdId(string id)
    {//async Task<Film>

        HttpClient client = new HttpClient();
        try
        {
            HttpResponseMessage response = await client.GetAsync($"https://www.omdbapi.com/?i={id}&page=1&type=movie&apikey={apiKey}");
            string? str = await response.Content.ReadAsStringAsync();
            try
            {
                Film result;
                OmdbFilmDetail? robert2 = JsonSerializer.Deserialize<OmdbFilmDetail>(str);
                if (robert2 == null)
                {
                    throw new InvalidOperationException("La réponse de l'API OMDB est nulle ou invalide!!!!!!");
                }
                if (robert2.Notes == null ||robert2.Notes.Where(u => (u.Source == "Rotten Tomatoes"))==null)
                {
                    result = new Film(robert2.Title, robert2.ImdbId ,robert2.Poster, Convert.ToInt32(robert2.Year), robert2.Plot, robert2.Released, "inconnu");
                }
                else{
                    result = new Film(robert2.Title, robert2.ImdbId ,robert2.Poster, Convert.ToInt32(robert2.Year), robert2.Plot, robert2.Released, robert2.Notes.Where(u => (u.Source == "Rotten Tomatoes")).ToList()[0].Value);
                }
                return result;
            }
            catch(InvalidOperationException)
            {
                Console.WriteLine("La réponse de l'API OMDB est nulle ou invalide!!!!!!.");
                return null;
            }
        }
        catch(HttpRequestException e)
        {
            Console.WriteLine($"La requête à OMDB a échoué avec le code d'état HTTP : {e.Message}");
            return null;
        }
    }
}