using System.Security.Claims;
using Microsoft.IdentityModel.Tokens;
using System.IdentityModel.Tokens.Jwt;
using System.Text;

using TrackerDeFavorisApi.Models;

namespace TrackerDeFavorisApi.Services;
public class JwtService {

    public string? JwtKey {get;}

    public JwtService(IConfiguration configuration)
    {
        JwtKey = configuration["JWTKey"];
    }

    public static string toto(int id, string nom, Role role, string? JwtKey) {

        Claim[] claims = new[]
        {
            new Claim("Id", id.ToString()),
            new Claim(ClaimTypes.Name, nom),
            new Claim(ClaimTypes.Role, role.ToString()),
        };

        SymmetricSecurityKey key = new SymmetricSecurityKey(
            Encoding.UTF8.GetBytes(JwtKey!)
        );
        
        SigningCredentials credentials = new SigningCredentials(
            key, 
            SecurityAlgorithms.HmacSha256
        );

        JwtSecurityToken token = new JwtSecurityToken(
            issuer: "localhost:5166", // Qui émet le token ici c'est notre API
            audience: "localhost:5166", // Qui peut utiliser le token ici c'est notre API
            claims: claims, // Les informations sur l'utilisateur
            expires: DateTime.Now.AddMinutes(3000), // Date d'expiration du token
            signingCredentials: credentials // La clé secrète
        );

        string tokenString = new JwtSecurityTokenHandler().WriteToken(token);

        return tokenString;
    }
}