using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.EntityFrameworkCore;

namespace TrackerDeFavorisApi.Models;
public class BaseContext : DbContext
{
    public BaseContext(DbContextOptions<BaseContext> options) : base(options) {}
    protected override void OnConfiguring(DbContextOptionsBuilder options)
    {
        // Connexion a la base sqlite
        options.UseSqlite("Data Source=Base.db");
    }

    public DbSet<User> User {get; set;} = null!;
    public DbSet<Film> Film {get; set;} = null!;
    public DbSet<Favorite> Favorite {get; set;} = null!;
}