using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.IdentityModel.Tokens;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Authorization;
using TrackerDeFavorisApi.Models;
using TrackerDeFavorisApi.Services;

namespace TrackerDeFavorisApi.Controllers
{
    [Authorize]
    [Route("api/[controller]")]
    [ApiController]
    public class OmdbController : ControllerBase
    {

        private OmdbService _omdbs;
        private readonly BaseContext _context;

        public OmdbController(OmdbService s, BaseContext ctx)
        {
            _omdbs = s;
            _context = ctx;

        }
        // GET api/<OmdbController>/search/{title}



        [HttpGet("search/{title}")]
        [Authorize(Roles="Admin")]
        public async Task<ActionResult<List<Film>>> GetOmdbFilmFromTitle(string title)
        {
            var str = await _omdbs.SearchByTitle(title);
            if (str == null)
            {
                return NotFound();
            }
            return Ok(str);
        }
        
        [HttpGet("import/{imdbId}")]
        [Authorize(Roles="Admin")]
        public async Task<ActionResult<Film>> GetOmdbFilmFromId(string imdbId)
        {
            Film? film = await _omdbs.GetByImbdId(imdbId);

            if (film == null) {
                return NotFound();
            }

            if (_context.Film.Where(f => f.Title == film.Title).Count() == 0) {
                _context.Film.Add(film);
                await _context.SaveChangesAsync();

                return Ok(film);
            } else {
                return Conflict();
            }
        }
    }
}