using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.IdentityModel.Tokens;
using Microsoft.AspNetCore.Authorization;
using TrackerDeFavorisApi.Models;
using System.Security.Claims;
using System.Threading.Tasks;

namespace TrackerDeFavorisApi.Controllers
{
    [Authorize]
    [Route("api/[controller]")]
    [ApiController]
    public class FavoriteController : ControllerBase
    {
        private readonly BaseContext _context;

        public FavoriteController(BaseContext ctx) {
            _context = ctx;
        }


        // GET api/<FavoriteController>/5
        [HttpGet("{id}")]
        [Authorize]
        public async Task<ActionResult<Favorite>> GetFavorite(int id)
        {
                var favorite = await _context.Favorite.FindAsync(id);

                if (favorite == null) {
                    return NotFound();
                }

                return Ok(favorite);
        }

        // GET api/<FavoriteController>/list/4
        [HttpGet("list/{userId}")]
        [AllowAnonymous]
        public ActionResult<IEnumerable<Favorite>> GetFavoritesByUser(int userId)
        {
            IEnumerable<Favorite> listFavorites = _context.Favorite.Where(f => f.UserId == userId);

            return Ok(listFavorites);
        }

        // GET api/<FavoriteController>/film/4
        [HttpGet("film/{filmId}")]
        [AllowAnonymous]
        public ActionResult<IEnumerable<Favorite>> GetFavoritesByFilm(int filmId)
        {
            IEnumerable<Favorite> listFavorites = _context.Favorite.Where(f => f.FilmId == filmId);

            return Ok(listFavorites);
        }

        // GET api/<FavoriteController>/1/2
        [HttpGet("{userId}/{filmId}")]
        [Authorize]
        public ActionResult<bool> IsFavorite(int userId, int filmId)
        {
            IEnumerable<Favorite> listFavorites = _context.Favorite.Where(f => (f.UserId == userId) && (f.FilmId == filmId));

            Console.WriteLine(listFavorites.Count());

            return Ok(listFavorites.Any());
        }

        // POST api/<FavoriteController>/add
        //[HttpPost("add")]
        [HttpPost("add/{filmId}")]
        [Authorize]
        public async Task<ActionResult<Favorite>> AddFavorite(int filmId) {
            int userId = int.Parse(User!.FindFirst("Id")!.Value);
            
            int a = _context.Favorite.Where(f =>(f.FilmId == filmId)&&(f.UserId==userId)).Count();
            if (a==0){
                    Favorite favorite = new Favorite(userId, filmId);

                    _context.Favorite.Add(favorite);
                    await _context.SaveChangesAsync();

                    return Ok(favorite);
            }
            else{
                 return StatusCode(409,"Le nom d'utilisateur existe déjà. Veuillez en choisir un autre.");
            }
        }

        // DELETE api/<FavoriteController>/remove/userId/filmId
        [HttpDelete("remove/{filmId}")]
        [Authorize]
        public async Task<ActionResult<Favorite>> DeleteFavorite(int filmId)
        {
            int userId = int.Parse(User!.FindFirst("Id")!.Value);

            List<Favorite> favorite = _context.Favorite.Where(f => f.UserId == userId && f.FilmId == filmId).ToList();

            if (favorite.Count==0){
                return NotFound("Ce favori n'existe pas, veuillez réessayer.");
            }

            _context.Favorite.Remove(favorite.First());
            await _context.SaveChangesAsync();

            return Ok();
        }
    }
}
