# ZZ2 - Services Web C-Sharp
Lien de l'énoncé : [https://csharp.nouvet.fr/](https://csharp.nouvet.fr/)
clé API (adress mail de jean): fa9b2aba

### Partie API

- Utilise l'authentification JWT
- Utilise l'entity framework pour la base de données sqlite
- Controller User:
    - Récupérer la liste des utilisateurs (Id, Pseudo, Role)
    - Récupérer un utilisateur par son pseudo et son mot de passe (login)
    - Ajouter un utilisateur (register)
    - Modifier un utilisateur (Pseudo, Password, Role)
    - Supprimer un utilisateur
    - Le mot de passe est hashé et n'est pas renvoyé
- Controller Favorite:
    - Récupérer les favoris d'un utilisateur
    - Ajouter un favori
    - Supprimer un favori
- Controller Movie:
    - Récupérer les films
    - Supprimer un film
- Controller OMDB:
    - Rechercher un film par son titre
    - Importer des films depuis l'API OMDB
- Utilisation de la configuration pour les secrets (Clé d'API OMDB, Secret JWT)
- Utilisation de l'injection de dépendance
- **Utilisation du méchanisme d'authentification pour protéger les routes**
- Configuration du JWT
- 2 Services (JWT et OMDB)
- Gestion des erreurs (try catch, throw)
- Réponse de code HTTP approprié 200, 404, 500, ...
- Utilisation de async await pour les appels API, et l'accès BDD

### Partie Blazor 

- Formulaire de login
    - Message d'erreur : Login / MdP incorrects / register
- Formulaire d'inscription
    - Empêcher les doublons
- Page de liste des films:
    - Les films sont affichés sous forme de carte dans un composant
    - On peut ajouter/retirer un film aux favoris
    - Cacher le bouton Ajouter aux favoris si aucun utilisateur connecté
- Liste des utilisateurs avec leur rôles
- Page qui affiche les films favoris d'un utilisateur
    - Accès aux favoris d'un autre utilisateur dont on connaît le pseudo
- Page admin pour importer des films
    - Gérer les permissions
    - Ce serait bien d'afficher instantanément les films quand on les recherche
- Présence de 4 services pour communiquer avec l'API:
    - AuthService
    - UserService
    - FavoriteService
    - MovieService
- Lors de l'authentification, le token JWT est stocké dans le local storage
- Le token JWT est envoyé dans le header de chaque requête API qui le nécessite (8.17)
- Les pages sont protégées en fonction des rôles
- Les services sont injectés et appelés dans les composants
- Utilisation de async await pour les appels API

### Ajouts

- Agrandir la carte pour afficher des informations supplémentaires sur le film
- Pour chaque film, affichage du nombre de personnes l'ayant ajouté à leurs favoris
- Les administrateurs peuvent modifier le rôle des autres utilisateurs