using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Identity.Data;
using FavTracker.Models;
using System.Text.Json;
using System.Text;

public class UserService {
    public async Task<User> getUser(UserAndJwt user, int id) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/User/{id}");

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        User? u = await response.Content.ReadFromJsonAsync<User>();

        if (u == null) {
            throw new InvalidOperationException("L'utilisateur obtenu lors de la requête est incorrect.");
        }

        return u;
    }

    public async Task<List<User>> UserList(UserAndJwt user) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        HttpResponseMessage response = await client.GetAsync("http://localhost:5166/api/User");

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment d'obtenir la liste des utilisateurs.");
        }

        List<User>? users = await response.Content.ReadFromJsonAsync<List<User>>();

        if (users == null) {
            throw new InvalidOperationException("La liste d'utilisateurs obtenue lors de la requête est incorrecte.");
        }

        return users;
    }

    public async Task<UserAndJwt> UserLogin(UserInfo ui) {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.PostAsJsonAsync("http://localhost:5166/api/User/login", ui);

        UserAndJwt? userAndJwt = null;

        if (response.IsSuccessStatusCode) {

            userAndJwt = await response.Content.ReadFromJsonAsync<UserAndJwt>();

            if (userAndJwt == null) {
                throw new InvalidOperationException("L'utilisateur obtenu lors de la requête est incorrect.");
            }

        } else {

            if (response.StatusCode == System.Net.HttpStatusCode.NotFound) {
                throw new HttpRequestException("Aucune information n'a été spécifiée. Veuillez réessayer.");
            } else if (response.StatusCode == System.Net.HttpStatusCode.Unauthorized) {
                throw new HttpRequestException("L'identifiant ou le mot de passe est incorrect. Veuillez réessayer.");
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
            }

        }

        return userAndJwt;
    }

    public async Task<User> UserRegister(UserInfo ui) {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.PostAsJsonAsync("http://localhost:5166/api/User/register", ui);

        User? user = null;

        if (response.IsSuccessStatusCode) {

            user = await response.Content.ReadFromJsonAsync<User>();

            if (user == null) {
                throw new InvalidOperationException("L'utilisateur obtenu lors de la requête est incorrect.");
            }

        } else {

            if (response.StatusCode == System.Net.HttpStatusCode.Conflict) {
                throw new HttpRequestException("Cet identifiant est déjà pris. Veuillez choisir un autre identifiant.");
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de l'inscription.");
            }

        }

        return user;
    }

    public async Task<User> UserChangeRole(UserAndJwt user, int userId, Role role) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        string json = JsonSerializer.Serialize(new User("", "", role));

        HttpResponseMessage response = await client.PutAsync($"http://localhost:5166/api/User/{userId}", new StringContent(json, UnicodeEncoding.UTF8, "application/json"));
        
        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        User? updatedUser = await response.Content.ReadFromJsonAsync<User>();

        if (updatedUser == null) {
            throw new InvalidOperationException("L'utilisateur obtenu lors de la requête est incorrect.");
        }

        return updatedUser;
    }

    public async Task UserDelete(UserAndJwt admin, User user) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + admin.Token);

        HttpResponseMessage response = await client.DeleteAsync($"http://localhost:5166/api/User/{user.Id}");

        if (response.StatusCode != System.Net.HttpStatusCode.NoContent) {
            throw new HttpRequestException("Il y a eu une erreur au moment de supprimer l'utilisateur.");
        }
    }

    public async Task<int?> GetUserIdByPseudo(UserAndJwt util, string name) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + util.Token);

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/User/find/{name}");

        Console.WriteLine($"Response Status Code: {response.StatusCode}");
        Console.WriteLine($"Response Content: {await response.Content.ReadAsStringAsync()}");

        if (!response.IsSuccessStatusCode)
        {
            throw new HttpRequestException("Cet utilisateur n'existe pas. Veuillez réessayer.");
        }

        User? user = await response.Content.ReadFromJsonAsync<User>();

        if (user == null)
        {
            throw new InvalidOperationException("L'utilisateur obtenu lors de la requête est incorrect.");
        }

        return user.Id;
    }


}