using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Identity.Data;
/*using System;
using System.Net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Identity;*/
using FavTracker.Models;

public class OmdbService {
    public async Task<List<Film>> getOmdbByTitle(UserAndJwt user, string title) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        Console.WriteLine($"http://localhost:5166/api/Omdb/search/{title}");

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Omdb/search/{title}");

        Console.WriteLine(response.StatusCode);

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        List<Film>? films = await response.Content.ReadFromJsonAsync<List<Film>>();

        if (films == null) {
            throw new InvalidOperationException("Le film omdb obtenu lors de la requête est incorrect.");
        }

        return films;
    }
    
    public async Task importOmdbByimdbId(UserAndJwt user, string imdbId) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);


        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Omdb/import/{imdbId}");

        if (response.IsSuccessStatusCode) {
            Film? film = await response.Content.ReadFromJsonAsync<Film>();

            if (film == null) {
                throw new InvalidOperationException("Le film omdb obtenu lors de la requête est incorrect.");
            }
        } else {
            if (response.StatusCode == System.Net.HttpStatusCode.Conflict) {
                throw new HttpRequestException("Ce film a déjà été importé.");
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
            }
        }
    }
}