using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Identity.Data;
using FavTracker.Models;
using FavTracker.Components.Pages;

public class FilmService {
    public async Task<Film> getFilm(int id) {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Film/{id}");

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        Film? film = await response.Content.ReadFromJsonAsync<Film>();

        if (film == null) {
            throw new InvalidOperationException("Le film obtenu lors de la requête est incorrect.");
        }

        return film;
    }

    public async Task<List<Film>> getFilms(string Title) {
        HttpClient client = new HttpClient();

        if (Title == null){
            throw new InvalidOperationException("la requete ne peut pas avoir d'argument null");
        }

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Film/search/{Title}");

        List<Film>? films;

        if (response.IsSuccessStatusCode) {
            films = await response.Content.ReadFromJsonAsync<List<Film>>();

            if (films == null) {
                throw new InvalidOperationException("La liste de films obtenue lors de la requête est incorrecte.");
            }
        } else {
            if (response.StatusCode == System.Net.HttpStatusCode.NotFound || response.StatusCode == System.Net.HttpStatusCode.BadRequest) {
                films = new List<Film>();
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
            }
        }

        return films;
    }

    public async Task<List<Film>> getFilms() {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.GetAsync("http://localhost:5166/api/Film");

        List<Film>? films;

        if (response.IsSuccessStatusCode) {
            films = await response.Content.ReadFromJsonAsync<List<Film>>();

            if (films == null) {
                throw new InvalidOperationException("La liste de films obtenue lors de la requête est incorrecte.");
            }
        } else {
            if (response.StatusCode == System.Net.HttpStatusCode.NotFound) {
                films = new List<Film>();
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
            }
        }

        return films;
    }

    public async Task<List<Film>> getFilmInfos(int[] ids) {
        HttpClient client = new HttpClient();

        string uri = "http://localhost:5166/api/Film/info";

        // Ajout des différents ids à l'URI

        foreach (int id in ids) {
            if (ids.First() == id) {
                uri += "?";
            } else {
                uri += "&";
            }

            uri += $"ids={id}";
        }

        Console.WriteLine(uri);

        HttpResponseMessage response = await client.GetAsync(uri);

        Console.WriteLine(response.StatusCode);

        List<Film>? films;

        if (response.IsSuccessStatusCode) {
            films = await response.Content.ReadFromJsonAsync<List<Film>>();

            if (films == null) {
                throw new InvalidOperationException("La liste de films obtenue lors de la requête est incorrecte.");
            }
        } else {
            if (response.StatusCode == System.Net.HttpStatusCode.NotFound) {
                films = new List<Film>();
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
            }
        }

        return films;
    }
}