using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Identity.Data;
using FavTracker.Models;
using System.Threading.Tasks;
using System.Collections.Generic;

public class FavoriteService {

    public async Task<List<Favorite>> getFavorites(UserAndJwt user) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);
        
        int userid = user.User!.Id;

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Favorite/list/{userid}");

        Console.WriteLine(response.StatusCode);

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        Console.WriteLine(response.Content);

        IEnumerable<Favorite>? favorite = await response.Content.ReadFromJsonAsync<IEnumerable<Favorite>>();

        if (favorite == null) {
            throw new InvalidOperationException("La liste de favoris obtenue est incorrecte");
        }

        return favorite.ToList();
    }

    public async Task<List<Favorite>> getFavoritesByFilm(int filmid) {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Favorite/film/{filmid}");

        Console.WriteLine(response.StatusCode);

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        Console.WriteLine(response.Content);

        IEnumerable<Favorite>? favorite = await response.Content.ReadFromJsonAsync<IEnumerable<Favorite>>();

        if (favorite == null) {
            throw new InvalidOperationException("La liste de favoris obtenue est incorrecte");
        }

        return favorite.ToList();
    }

    public async Task<List<Favorite>> getFavoritesByUser(int userid) {
        HttpClient client = new HttpClient();
        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Favorite/list/{userid}");

        Console.WriteLine(response.StatusCode);

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        Console.WriteLine(response.Content);

        IEnumerable<Favorite>? favorite = await response.Content.ReadFromJsonAsync<IEnumerable<Favorite>>();

        if (favorite == null) {
            throw new InvalidOperationException("La liste de favoris obtenue est incorrecte");
        }

        return favorite.ToList();
    }

    public async Task<Boolean> isFavorite(UserAndJwt user, int filmid) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);
        
        int userid = user.User!.Id;

        HttpResponseMessage response = await client.GetAsync($"http://localhost:5166/api/Favorite/{userid}/{filmid}");

        Console.WriteLine(response.StatusCode);

        if (!response.IsSuccessStatusCode) {
            throw new HttpRequestException("Il y a eu une erreur au moment de la connexion.");
        }

        bool? isFav = await response.Content.ReadFromJsonAsync<bool>();

        Console.WriteLine(isFav + " " + userid + " " + filmid);

        if (isFav == null) {
            throw new InvalidOperationException("Il y a eu un problème au moment de savoir si le film est en favori.");
        }

        return isFav == true;
    }

    public async Task<Favorite> addFavorite(UserAndJwt user, int filmId) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        int userid = user.User!.Id;
        Console.WriteLine($"!!!!!!!!!!!!!!!!!!!!!!!!!!!{filmId},{userid}:::::::::::::");
        HttpResponseMessage response = await client.PostAsync($"http://localhost:5166/api/Favorite/add/{filmId}", null);
        Console.WriteLine($"!!!!!!!!!!!!!!!!!!!!!!!!!!!{filmId},{userid}:::::::::::::");
        Favorite? favorite = null;

        if (response.IsSuccessStatusCode) {

            favorite = await response.Content.ReadFromJsonAsync<Favorite>();

            if (favorite == null) {
                throw new InvalidOperationException("Le favori obtenu lors de la requête est incorrect.");
            }

        } else {

            if (response.StatusCode == System.Net.HttpStatusCode.Conflict) {
                throw new HttpRequestException("Ce film est déjà présent dans vos favoris.");
            } else {
                throw new HttpRequestException("Il y a eu une erreur au moment de l'ajout du favori.");
            }

        }

        return favorite;
    }

    public async Task<Favorite?> removeFavorite(UserAndJwt user, int filmid) {
        HttpClient client = new HttpClient();
        client.DefaultRequestHeaders.Add("Authorization", "Bearer " + user.Token);

        int userid = user.User!.Id;
        HttpResponseMessage response = await client.DeleteAsync($"http://localhost:5166/api/Favorite/remove/{filmid}");

        Console.WriteLine(response.StatusCode);

        if (response.IsSuccessStatusCode) {
            return null;
        } else {
            throw new HttpRequestException("Il y a eu une erreur au moment de la suppression du favori.");
        }
    }
}