using FavTracker.Components;
using FavTracker.Services;
using Microsoft.AspNetCore.Components.Authorization;
using Microsoft.AspNetCore.Authentication.Cookies;

namespace FavTracker;

public class Program
{
    public static void Main(string[] args)
    {
        var builder = WebApplication.CreateBuilder(args);


        builder.Services.AddSingleton<FavoriteService>();
        builder.Services.AddSingleton<FilmService>();
        builder.Services.AddSingleton<OmdbService>();
        builder.Services.AddSingleton<UserService>();
        builder.Services.AddScoped<AuthenticationStateProvider, AuthProvider>();
        builder.Services.AddAuthenticationCore();
        builder.Services.AddAuthentication(o =>
                            {
                                o.DefaultAuthenticateScheme = CookieAuthenticationDefaults.AuthenticationScheme;
                            })
                        .AddCookie(CookieAuthenticationDefaults.AuthenticationScheme, options =>
                            {
                                options.Cookie.Name = "auth_cookie";
                                options.LoginPath = "/login";
                                options.AccessDeniedPath = "/login";
                            });


        // Add services to the container.
        builder.Services.AddRazorComponents()
            .AddInteractiveServerComponents();

        var app = builder.Build();

        // Configure the HTTP request pipeline.
        if (!app.Environment.IsDevelopment())
        {
            app.UseExceptionHandler("/Error");
        }

        

        app.UseStaticFiles();
        app.UseAntiforgery();

        app.UseAuthentication();
        app.UseAuthorization();

        app.MapRazorComponents<App>().AddInteractiveServerRenderMode();

        app.Run();
    }
}
