using System;
using System.Text.Json.Serialization;

namespace FavTracker.Models;

public enum Role
{
    User,
    Admin
}

public class User
{
    public string Pseudo { get; set; }
    public string Password { get; set; }
    public int Id { get; set; }
    public Role Role { get; set; }

    public User(string pseudo, string password) : this(pseudo,password,Role.User) {
    }

    [JsonConstructorAttribute]
    public User(string pseudo, string password, Role role) {
        Pseudo = pseudo;
        Password = password;
        Role = role;
    }

    public override string ToString() {
        return $"Id : {Id}, Pseudo : {Pseudo}, Role : {Role}";
    }
}