#ifndef TEXTURES_H_
#define TEXTURES_H_

#include <SDL2/SDL_render.h>
#include <SDL2/SDL_ttf.h>

#define FIRE_FRAMES 101
#define MLG_FRAMES 151
#define ROMEO_FRAMES 161
#define ANTONIN_FRAMES 29

SDL_Texture * get_texture(char * file_image_name, SDL_Window * window, SDL_Renderer * renderer);
SDL_Texture * get_text_texture(char * text, TTF_Font * font, SDL_Color color, SDL_Window * window, SDL_Renderer * renderer);

void load_all_textures(SDL_Texture ** banner, SDL_Texture ** large_banner, SDL_Texture ** table, SDL_Texture ** board_background,
                       SDL_Texture **** pieces, SDL_Texture *** fire, SDL_Texture *** mlg, SDL_Texture *** romeo, SDL_Texture *** antonin,
                       SDL_Window * window, SDL_Renderer * renderer);

void destroy_all_textures(SDL_Texture * banner, SDL_Texture * large_banner, SDL_Texture * table, SDL_Texture * board_background,
                          SDL_Texture *** pieces, SDL_Texture ** fire, SDL_Texture ** mlg, SDL_Texture ** romeo, SDL_Texture ** antonin);

#endif