#include <SDL2/SDL_render.h>
#include <stdbool.h>

#include "display.h"
#include "display_effects.h"
#include "textures.h"

SDL_Texture * get_texture(char * file_image_name, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Surface * image = NULL;
    SDL_Texture * texture = NULL;

    image = IMG_Load(file_image_name);

    if (image == NULL) {
        exit_sdl(0, "Error when loading the image", window, renderer);
    }

    texture = SDL_CreateTextureFromSurface(renderer, image);
    SDL_FreeSurface(image);

    if (texture == NULL) {
        exit_sdl(0, "Surface to texture transformation failed", window, renderer);
    }

    return texture;
}

SDL_Texture * get_text_texture(char * text, TTF_Font * font, SDL_Color color, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Surface * text_surface = NULL;
    SDL_Texture * text_texture = NULL;

    // Joueur du haut

    text_surface = TTF_RenderText_Blended(font, text, color); // création du texte dans la surface 

    if (text_surface == NULL) {
        exit_sdl(0, "Can't create text surface", window, renderer);
    }

    text_texture = SDL_CreateTextureFromSurface(renderer, text_surface);

    if (text_texture == NULL) {
        exit_sdl(0, "Can't create texture from surface", window, renderer);
    }

    SDL_FreeSurface(text_surface);

    return text_texture;
}

void load_all_textures(SDL_Texture ** banner, SDL_Texture ** large_banner, SDL_Texture ** table, SDL_Texture ** board_background,
                       SDL_Texture **** pieces, SDL_Texture *** fire, SDL_Texture *** mlg, SDL_Texture *** romeo, SDL_Texture *** antonin,
                       SDL_Window * window, SDL_Renderer * renderer) {

    *banner = get_texture("../img/banners/banner.png", window, renderer);
    *large_banner = get_texture("../img/banners/large_banner.png", window, renderer);

    display_banner_pop_up(*banner, "Chargement...", window, renderer);
    SDL_RenderPresent(renderer);

    *table = get_texture("../img/table2.jpg", window, renderer);
    *board_background = get_texture("../img/board/board.png", window, renderer);

    *pieces = malloc(2 * sizeof(SDL_Texture **));
    char piece_filename[64];

    if (*pieces) {
        for (int i = 0; i < 2; ++i) {
            (*pieces)[i] = malloc((NB_PIECES+1) * sizeof(SDL_Texture *));

            if ((*pieces)[i]) {
                for (int j = 0; j < NB_PIECES; ++j) {
                    sprintf(piece_filename, "../img/pieces/%d/%d.png", i, j);
                    (*pieces)[i][j] = get_texture(piece_filename, window, renderer);
                }

                sprintf(piece_filename, "../img/pieces/%d/unknown.png", i);
                (*pieces)[i][NB_PIECES] = get_texture(piece_filename, window, renderer);
            }
        }
    }

    *fire = malloc(FIRE_FRAMES * sizeof(SDL_Texture *));

    for (int i = 0; i < FIRE_FRAMES; ++i) {
        sprintf(piece_filename, "../img/fire/frame_%d.png", i);
        (*fire)[i] = get_texture(piece_filename, window, renderer);
    }

    *mlg = malloc(MLG_FRAMES * sizeof(SDL_Texture *));

    for (int i = 0; i < MLG_FRAMES; ++i) {
        sprintf(piece_filename, "../img/mlg/frame_%d.png", i);
        (*mlg)[i] = get_texture(piece_filename, window, renderer);
    }

    *romeo = malloc(ROMEO_FRAMES * sizeof(SDL_Texture *));

    for (int i = 0; i < ROMEO_FRAMES; ++i) {
        sprintf(piece_filename, "../img/romeo/romeo%d.jpg", i);
        (*romeo)[i] = get_texture(piece_filename, window, renderer);
    }

    *antonin = malloc(ANTONIN_FRAMES * sizeof(SDL_Texture *));

    for (int i = 0; i < ANTONIN_FRAMES; ++i) {
        sprintf(piece_filename, "../img/antonin/antonin%d.jpg", i);
        (*antonin)[i] = get_texture(piece_filename, window, renderer);
    }
}

void destroy_all_textures(SDL_Texture * banner, SDL_Texture * large_banner, SDL_Texture * table, SDL_Texture * board_background,
                          SDL_Texture *** pieces, SDL_Texture ** fire, SDL_Texture ** mlg, SDL_Texture ** romeo, SDL_Texture ** antonin) {
    for (int i = 0; i < ROMEO_FRAMES; ++i) {
        SDL_DestroyTexture(romeo[i]);
    }
    free(romeo);

    for (int i = 0; i < ANTONIN_FRAMES; ++i) {
        SDL_DestroyTexture(antonin[i]);
    }
    free(antonin);
    
    for (int i = 0; i < MLG_FRAMES; ++i) {
        SDL_DestroyTexture(mlg[i]);
    }
    free(mlg);
    
    for (int i = 0; i < FIRE_FRAMES; ++i) {
        SDL_DestroyTexture(fire[i]);
    }
    free(fire);

    for (int i = 0; i < 2; ++i) {
        for (int j = 0; j < NB_PIECES; ++j) {
            SDL_DestroyTexture(pieces[i][j]);
        }
        free(pieces[i]);
    }
    free(pieces);

    SDL_DestroyTexture(banner);
    SDL_DestroyTexture(large_banner);

    SDL_DestroyTexture(board_background);
    SDL_DestroyTexture(table);
}