#include "board.h"
#include "entity.h"
#include "list.h"
#include "move.h"
#include <stdio.h>
#include <stdlib.h>


// LEGACY
coord_t find_randomth_moving_piece_on_board(board_t board, int max_inclusive, player_t player) {
    int k = 0;
    piece_t selected_piece;
    coord_t coord;

    int index = rand()%(max_inclusive+1);

    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            selected_piece = board[i][j];
            if (is_moving_piece(selected_piece) && (selected_piece.owner_id == player.id)) {
                k += 1;
                if (k == index) {
                    coord.x = i;
                    coord.y = j;
                    return coord;
                }
            }
        }
    }
    coord.x = -3;
    coord.y = -3;
    return coord;
}

player_id _internal_simulation(board_t board, player_t * starting_player, player_t * responding_player) {
    player_t * tmp;
    move_t move;

    while (!is_player_loser(*starting_player, board)) {
        list_t * available_move = possible_moves(board, starting_player);
        
        node_t * random_node = get_node_by_index(available_move, rand()%available_move->length);


        move[0] = random_node->move[0];
        move[1] = random_node->move[1];
        
        // Résolution du coup
        take_move(board, move, starting_player, responding_player, 1, NULL);

        // Swap des joeurs
        tmp = starting_player;
        starting_player = responding_player;
        responding_player = tmp;
    }

    // On donne l'id de l'autre car il y aura eu un switch à la fin de la boucle
    return starting_player->id;
}


// Retourne le gagnant de la simulation
player_id simulate_from_board(board_t board, player_t starting_player, player_t responding_player) {
    board_t board_copied;
    copy_board(board, board_copied);
    return _internal_simulation(board_copied, &starting_player, &responding_player);

}