#include <SDL2/SDL_render.h>
#include <SDL2/SDL_ttf.h>
#include <stdbool.h>

#include "input.h"
#include "display_menu.h"
#include "textures.h"
#include "menu.h"

#define NB_CHOICES 2

int menu(SDL_Texture * background, SDL_Texture * banner, SDL_Texture * large_banner, SDL_Window * window, SDL_Renderer * renderer) {
    int nb_opponents = -1;

    SDL_bool menu_on = SDL_TRUE;
    SDL_bool update = SDL_TRUE;
    SDL_Event event;

    int old_x = 0, old_y = 0, x = 0, y = 0;

    SDL_Texture * icons[NB_CHOICES];

    char icon_filename[64];

    for (int i = 1; i <= NB_CHOICES; ++i) {
        sprintf(icon_filename, "../img/icons/%dp.png", i);
        icons[i-1] = get_texture(icon_filename, window, renderer);
    }

    while (menu_on) {
        if (SDL_PollEvent(&event)) {
            switch (event.type) {
                case SDL_QUIT:
                    menu_on = SDL_FALSE;
                    break;

                case SDL_MOUSEMOTION:
                    old_x = x;
                    old_y = y;

                    x = event.button.x;
                    y = event.button.y;

                    // Rajouter une condition pour éviter de surcharger la mémoire

                    if (is_new_button_hovered(2, old_x, old_y, x, y, window)) {
                        update = SDL_TRUE;
                    }

                    break;

                case SDL_MOUSEBUTTONUP:
                    switch (event.button.button) {
                        case SDL_BUTTON_LEFT:
                            nb_opponents = get_button_value(2, event.button.x, event.button.y, window);

                            if (nb_opponents != -1) {
                                menu_on = SDL_FALSE;

                                update = SDL_TRUE;
                            }

                            break;

                        default:
                            break;
                    }
                    break;

                case SDL_WINDOWEVENT:
                    if (event.window.event == SDL_WINDOWEVENT_RESIZED) {
                        update = SDL_TRUE;
                    }
                    break;
                
                default:
                    break;
            }
        }

        if (update && menu_on) {
            display_menu(background, banner, large_banner, icons, x, y, window, renderer);
            update = SDL_FALSE;
        }
    }

    return nb_opponents;
}

void victory(SDL_Texture * background, SDL_Texture ** romeo, SDL_Texture ** antonin, SDL_Texture * large_banner, SDL_Texture * piece_flag,
             player_t * curr_player, bool mlg_ending, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_bool menu_on = SDL_TRUE;
    SDL_bool update = SDL_TRUE;
    SDL_Event event;

    double old_time, new_time;
    double frame = 0;
    int romeo_frame = 0, antonin_frame = 0;

    while (menu_on) {
        // Gestion des images

        old_time = new_time;
        new_time = SDL_GetTicks();

        frame += (new_time - old_time);

        if (mlg_ending && frame > 100) {
            frame = 0;
            update = SDL_TRUE;
        }

        if (SDL_PollEvent(&event)) {
            switch (event.type) {
                case SDL_QUIT:
                    menu_on = SDL_FALSE;
                    break;
                
                case SDL_MOUSEBUTTONUP:
                    switch (event.button.button) {
                        case SDL_BUTTON_LEFT:
                            menu_on = SDL_FALSE;
                            break;

                        default:
                            break;
                    }
                    break;

                case SDL_WINDOWEVENT:
                    if (event.window.event == SDL_WINDOWEVENT_RESIZED) {
                        update = SDL_TRUE;
                    }
                    break;
                
                default:
                    break;
            }
        }

        if (update) {
            if (mlg_ending) {
                display_mlg_victory_menu(romeo[romeo_frame], antonin[antonin_frame], large_banner, piece_flag, curr_player->id, window, renderer);
                romeo_frame = (romeo_frame + 1) % ROMEO_FRAMES;
                antonin_frame = (antonin_frame + 1) % ANTONIN_FRAMES;
            } else {
                display_victory_menu(background, large_banner, piece_flag, curr_player->id, window, renderer);
            }

            update = SDL_FALSE;
        }
    }  
}