#ifndef MCTS_H
#define MCTS_H

#define POOL_BASE_SIZE 300 

#include "board.h"
#include "entity.h"

//MCTS
typedef struct {
    board_t view_board;
    list_t * moves;
    player_t curr_player;
} mcts_node_t;

//RBTREE

enum nodeColor {
  RED,
  BLACK
};

typedef struct rb_node_t {
  mcts_node_t * data;
  int color;
  struct rb_node_t *link[2];
}rb_node_t;

rb_node_t * rbtCreateNode(mcts_node_t * data);
struct rb_node_t * rbtInsert(struct rb_node_t * root, mcts_node_t * data);
struct rb_node_t *  rbtDelete(struct rb_node_t * root, mcts_node_t * data);
void rbtDisplay(struct rb_node_t * node);

bool_t recherche_view(board_t view, mcts_node_t ** new_address, player_t * current_player);


void init_mcts(board_t start_board, player_t mcts_player, player_t human_player);

void mcts_take_move(board_t board, player_t * mcts_player, player_t * human_player, move_t * move, int * result);

#endif