#ifndef LIST_H_
#define LIST_H_

#include "utils.h"
#include "move.h"


typedef struct node{ //Noeud contenant un pointeur sur le board, et un sur le node suivant
    move_t move;
    int nb_win;
    int nb_try;
    struct node * next;
} node_t;

typedef struct list{ //Liste chaînée de board avec un pointeur sur sa fin
    int length;
    node_t * head;
    node_t * end;
} list_t;

//Tests multiples

bool_t is_list_null(list_t * l); //Renvoie vrai si la liste est nulle
bool_t is_empty_list(list_t * l); //Renvoie vrai si la liste est vide
bool_t is_node_null(node_t * node); //Renvoie vrai si le node est nul

//Création et opérations de base sur les listes

node_t * create_node(move_t move);
list_t * create_list(); // Alloue une nouvelle liste
list_t * list_merge(list_t *l, list_t * m); //Fusionne deux listes
list_t * list_add(list_t * l, move_t move); //Addition d'un board en tête de la liste
node_t * get_node_by_index(list_t * list, int i);

#endif