#include <stdio.h>
#include <stdlib.h>
#include "move.h"
#include "utils.h"
#include "list.h"

bool_t is_list_null(list_t * list) {
    if (list == NULL) {
        fprintf(stderr, "Liste nulle");
    }
    return (list == NULL);
}

bool_t is_empty_list(list_t * list) {
    if (!is_list_null(list)) {
        return (list->length == 0);
    } else {
        return 0;
    }
}

bool_t is_node_null(node_t * node) {
    if (node == NULL) {
        fprintf(stderr, "Node non alloué");
    }
    return (node == NULL);
}

node_t * create_node(move_t move) {
    node_t * node = malloc(sizeof(node_t));
    copy_move(move, node->move);
    node->next = NULL;
    node->nb_try = 0;
    node->nb_win = 0;
    return node;
}

list_t * create_list() {
    list_t * list = malloc(sizeof(list_t));
    if (!is_list_null(list)) {
        list->length = 0;
        list->head = NULL;
        list->end = NULL;
    }
    return list;
}

list_t * list_merge(list_t * list_1, list_t * list_2) {
    if ((is_list_null(list_1)) || (is_list_null(list_2))) {
        fprintf(stderr, "Tentative de merge d'une liste non allouée");
        return NULL;
    } else {
        if (is_empty_list(list_1)) {
            return list_2;
        } else {
            if (is_empty_list(list_2)) {
                return list_1;
            } else {
                list_1->length = list_1->length + list_2->length;
                list_1->end->next = list_2->head;
                list_1->end = list_2->end;
                free(list_2);
                return list_1;
            }
        }
    }
}

list_t * list_add(list_t * list, move_t move) {
    list_t * new_list;
    node_t * new_node;
    new_list = create_list();
    new_node = create_node(move);
    if (!(is_list_null(new_list)) && !(is_node_null(new_node))) {
        new_node->next = NULL;
        new_list->end = new_node;
        new_list->head = new_node;
        new_list->length = 1;
        list = list_merge(list, new_list);
    }
    return list;
}

node_t * get_node_by_index(list_t * list, int i) {
    if (i < list->length) {
        node_t * node = list->head;
        for (int j = 0; j < i; j++) {
            node = node->next;
        }
        return node;
    } else {
        fprintf(stderr, "Tentative d'accèder à un index qui n'existe pas dans une liste");
        return NULL;
    }
}