#include <stdbool.h>

#include "input.h"
#include "board.h"
#include "entity.h"

char is_new_button_hovered(int nb_buttons, int old_x, int old_y, int x, int y, SDL_Window * window) {
    return get_button_value(nb_buttons, old_x, old_y, window) != get_button_value(nb_buttons, x, y, window);
}

char get_button_value(int nb_buttons, int x, int y, SDL_Window * window) {
    char choice = -1;

    SDL_Rect
        window_dimensions = {0},
        box = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);

    box.w = 0.9 * window_dimensions.w / nb_buttons;
    box.h = 0.5 * window_dimensions.h;

    box.x = 0.025 * window_dimensions.w;
    box.y = 0.25 * window_dimensions.h;

    if ((x >= box.x) && (x <= window_dimensions.w - box.x) &&
        (y >= box.y) && (y <= box.y + box.h)) {

        for (int i = 0; i < nb_buttons; ++i) {
            if ((x >= box.x) && (x <= box.x + box.w)) {
                choice = i;
            }

            box.x += 0.975 * window_dimensions.w / nb_buttons;
        }

    }

    return choice;
}

/**
 * @brief Convertit les coordonnées d'un clic de souris en coordonnées de case dans la grille.
 * 
 * @param x Coordonnée x du clic de souris.
 * @param y Coordonnée y du clic de souris.
 * @param window Fenêtre SDL où le clic de souris a eu lieu.
 * @return coord_t Coordonnées de la case dans la grille.
 */
coord_t get_tile_coord(player_id curr_player, int x, int y, SDL_Window * window) {
    int i = -1;
    int j = -1;

    coord_t coord = {-1, -1}; // Coordonnées de la case dans la grille

    // Récupération des dimensions de la fenêtre

    SDL_Rect window_dimensions = {0};
    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);

    // Dimensions de la grille

    int length = 0.9 * window_dimensions.h;         // Taille de la grille
    float tile_size = (float) length / BOARD_SIZE;  // Taille d'une case

    int x_mid = window_dimensions.w / 2;
    int y_mid = window_dimensions.h / 2;

    int x_left = x_mid - length / 2;
    int x_right = x_mid + length / 2;

    int y_up = y_mid - length / 2;
    int y_down = y_mid + length / 2;

    int x_stash_left = length / 32;
    int x_stash_right = (window_dimensions.w - length) / 2.0 - length / 32.0;

    int y_stash_up = window_dimensions.h - length;
    int y_stash_down = window_dimensions.h - length / 16;

    if (curr_player == player_1) {
        x_stash_left = (x_stash_right - x_stash_left) + length + 3 * x_stash_left;
        x_stash_right = window_dimensions.w - length / 32;
    }

    // Vérifier si le clic est dans la grille

    if (x >= x_left && x <= x_right && y >= y_up && y <= y_down) {

        j = (x - x_left) / tile_size; // Calcul de la colonne
        i = (y - y_up) / tile_size;   // Calcul de la ligne

    } else if (x >= x_stash_left && x <= x_stash_right && y >= y_stash_up && y <= y_stash_down) {
        i = -1;
        j = (y - y_stash_up) * NB_PIECES / (y_stash_down - y_stash_up);
    }

    coord.x = i; // Assigner la ligne
    coord.y = j; // Assigner la colonne

    return coord; // Retourner les coordonnées de la case dans la grille
}

bool is_ok_button(player_id curr_player, int x, int y, SDL_Window * window) {
    // Récupération des dimensions de la fenêtre

    SDL_Rect window_dimensions = {0};
    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);

    // Dimensions de la grille

    int length = 0.9 * window_dimensions.h;         // Taille de la grille

    int x_stash_left = length / 32;
    int x_stash_right = (window_dimensions.w - length) / 2.0 - length / 32.0;

    int y_stash_up = (window_dimensions.h - length / 8) / 2;
    int y_stash_down = (window_dimensions.h - length / 8) / 2 + length / 8;

    if (curr_player == player_0) {
        x_stash_left = (x_stash_right - x_stash_left) + length + 3 * x_stash_left;
        x_stash_right = window_dimensions.w - length / 32;
    }

    return (x >= x_stash_left && x <= x_stash_right && y >= y_stash_up && y <= y_stash_down);
}