#ifndef ENTITY_H
#define ENTITY_H

#include "utils.h"

#define NB_PIECES 12
#define SUM_MOVING_PIECE 33

typedef enum {
    player_0 = 0,
    player_1 = 1,
    player_nil = -1,
    player_barrier = -2
} player_id;

typedef enum {
    piece_unknown = -2,
    piece_nil = -1,
    flag,
    spy,
    scout,
    engineer,
    sergeant,
    lieutenant,
    captain,
    major,
    colonel,
    general,
    marshal,
    bomb
} piece_rank;

typedef struct piece {
    player_id owner_id;
    piece_rank rank;
    bool_t has_attacked;
} piece_t;

typedef struct player {
    player_id id;
    int stash[NB_PIECES];
} player_t;

player_t get_player(player_id id);

bool_t is_moving_piece(piece_t piece);

piece_t get_blank_piece();

bool_t is_player_stash_empty(player_t player);

int get_number_of_moving_piece_in_stash(player_t player);

piece_rank pop_random_rank_from_stash(player_t * player);

void copy_player(player_t * src, player_t * dst);

#endif