#include "entity.h"
#include "utils.h"
#include <stdlib.h>

player_t get_player(player_id id) {
    player_t player = {id, {1, 1, 8, 5, 4, 4, 4, 3, 2, 1, 1, 6}};
    return player;
}

bool_t is_moving_piece(piece_t piece){
    return ((piece.rank > flag) && (piece.rank<bomb));
}

piece_t get_blank_piece() {
    piece_t piece = {player_nil, piece_nil, 0};
    return piece;
}

int get_number_of_moving_piece_in_stash(player_t player) {
    int sum;
    for (int i = 1; i < NB_PIECES-1 ; i++) {
        sum += player.stash[i];
    }

    return sum;
}

bool_t is_player_stash_empty(player_t player){
    bool_t bool = 1;
    int i = 0;
    while (bool && i<12){
        bool = (player.stash[i] == 0) && bool;
        i++;
    }
    return bool;
}

piece_rank pop_random_rank_from_stash(player_t * player) {
    piece_rank rank;
    do { // On tente de piocher au hasard une pièce qui a des exemplaire dans la stash
        rank = rand()%NB_PIECES;

    } while (player->stash[rank] <= 0);

    player->stash[rank]--;
    return rank;
}

void copy_player(player_t * src, player_t * dst) {
    dst->id = src->id;
    for (int i = 0; i < NB_PIECES; i++) {
        dst->stash[i] = src->stash[i];
    }
}