#include <SDL2/SDL_rect.h>
#include <SDL2/SDL_render.h>
#include <SDL2/SDL_surface.h>
#include <SDL2/SDL_ttf.h>
#include <stdbool.h>

#include "display.h"
#include "display_effects.h"
#include "entity.h"
#include "textures.h"
#include "display_menu.h"

#define PLAYER_CHOICES 2
#define DIFFICULTY_CHOICES 4

void display_menu_title(SDL_Texture * banner, char * txt, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_banner = {0},
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Affichage de la bannière

    SDL_QueryTexture(banner, NULL, NULL, &source.w, &source.h);

    float zoom = (float) window_dimensions.h / (5 * source.h);

    pos_banner.w = source.w * zoom;
    pos_banner.h = source.h * zoom;

    pos_banner.x = (window_dimensions.w - pos_banner.w) / 2;
    pos_banner.y = (window_dimensions.h / 4 - pos_banner.h) / 2;

    SDL_RenderCopy(renderer, banner, &source, &pos_banner);

    // Importation de la police

    SDL_Color color = {0, 0, 0, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    // Affichage du texte

    text_texture = get_text_texture(txt, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);

    pos_txt.x = (window_dimensions.w - pos_txt.w) / 2;
    pos_txt.y = window_dimensions.h / 24;

    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);
}

void display_menu_button_text(SDL_Rect * button, char * text, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Importation de la police

    SDL_Color color = {255, 255, 255, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    // Affichage du texte

    text_texture = get_text_texture(text, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);
    
    pos_txt.x = button->x + (button->w - pos_txt.w) / 2;
    pos_txt.y = button->y + (button->h - pos_txt.h) / 2;

    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);
}

void display_menu_buttons(SDL_Texture * banner, SDL_Texture ** icons, int x, int y, int nb_buttons, char ** txts, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        icon_source = {0},
        window_dimensions = {0}, // Rectangle définissant la fenêtre
        box = {0},       // Rectangle définissant où la zone source doit être déposée dans le renderer
        icon_dest = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    box.w = 0.9 * window_dimensions.w / nb_buttons;
    box.h = 0.5 * window_dimensions.h;

    box.x = 0.025 * window_dimensions.w;
    box.y = 0.25 * window_dimensions.h;

    for (int i = 0; i < nb_buttons; ++i) {

        // Affichage de la bannière

        display_banner(banner, font, txts[i], box, window, renderer);

        SDL_QueryTexture(icons[i], NULL, NULL, &icon_source.w, &icon_source.h);

        float zoom = 0.25 * box.h / icon_source.h;

        icon_dest.w = icon_source.w * zoom;
        icon_dest.h = icon_source.h * zoom;

        icon_dest.x = box.x + (box.w - icon_dest.w) / 2;
        icon_dest.y = box.y + (box.h - icon_dest.h) / 4;

        SDL_RenderCopy(renderer, icons[i], &icon_source, &icon_dest);

        if ((x >= box.x) && (x <= box.x + box.w) && (y >= box.y) && (y <= box.y + box.h)) {
            SDL_SetRenderDrawColor(renderer, 0, 0, 0, 32);
            SDL_RenderFillRect(renderer, &box);
        }

        box.x += 0.975 * window_dimensions.w / nb_buttons;
    }
}

void display_menu_background(SDL_Texture * background, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},               // Rectangle définissant la zone de la texture à récupérer
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        destination = {0};          // Rectangle définissant où la zone source doit être déposée dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Affichage du fond

    SDL_QueryTexture(background, NULL, NULL, &source.w, &source.h);        // Dimensions de l'image

    destination = window_dimensions;

    SDL_RenderCopy(renderer, background, &source, &destination);
}

void display_menu_backgrounds(SDL_Texture * background1, SDL_Texture * background2, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source1 = {0},               // Rectangle définissant la zone de la texture à récupérer
        source2 = {0},               // Rectangle définissant la zone de la texture à récupérer
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        destination = {0};          // Rectangle définissant où la zone source doit être déposée dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Affichage du fond

    SDL_QueryTexture(background1, NULL, NULL, &source1.w, &source1.h);        // Dimensions de l'image
    SDL_QueryTexture(background2, NULL, NULL, &source2.w, &source2.h);        // Dimensions de l'image

    destination.w = window_dimensions.w / 2;
    destination.h = window_dimensions.h;
    destination.x = 0;
    destination.y = 0;

    SDL_RenderCopy(renderer, background1, &source1, &destination);

    destination.x += destination.w;

    SDL_RenderCopy(renderer, background2, &source2, &destination);
}

void display_menu(SDL_Texture * background, SDL_Texture * banner, SDL_Texture * large_banner, SDL_Texture ** icons,
                  int x, int y, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    SDL_Rect window_dimensions = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/GreatVibes-Regular.ttf", window_dimensions.h / 8);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    } 

    TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

    display_menu_background(background, window, renderer);
    display_menu_title(banner, "Stratego", font, window, renderer);

    char ** txts = malloc(PLAYER_CHOICES * sizeof(char *));

    if (txts) {
        for (int i = 0; i < PLAYER_CHOICES; ++i) {
            txts[i] = malloc(16 * sizeof(char));
        }

        sprintf(txts[0], "1 joueur");
        sprintf(txts[1], "2 joueurs");

        display_menu_buttons(large_banner, icons, x, y, PLAYER_CHOICES, txts, font, window, renderer);

        SDL_RenderPresent(renderer);

        for (int i = 0; i < PLAYER_CHOICES; ++i) {
            free(txts[i]);
        }
        free(txts);
    }

    TTF_CloseFont(font);
}

void display_victory_menu(SDL_Texture * background, SDL_Texture * banner, SDL_Texture * piece_flag,
                          player_id winner, SDL_Window * window, SDL_Renderer * renderer) {

    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    SDL_Rect window_dimensions = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/GreatVibes-Regular.ttf", window_dimensions.h / 8);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    }  

    TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

    display_menu_background(background, window, renderer);

    display_large_piece(piece_flag, window, renderer);

    if (winner == player_0) {
        display_banner_pop_up(banner, "Victoire des bleus !", window, renderer);
    } else {
        display_banner_pop_up(banner, "Victoire des rouges !", window, renderer);
    }

    SDL_RenderPresent(renderer);

    TTF_CloseFont(font);
}

void display_mlg_victory_menu(SDL_Texture * background1, SDL_Texture * background2, SDL_Texture * banner, SDL_Texture * piece_flag,
                              player_id winner, SDL_Window * window, SDL_Renderer * renderer) {

    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    SDL_Rect window_dimensions = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/GreatVibes-Regular.ttf", window_dimensions.h / 8);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    }  

    TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

    display_menu_backgrounds(background1, background2, window, renderer);

    display_large_piece(piece_flag, window, renderer);

    SDL_Rect subtitle = {0};

    subtitle.h = window_dimensions.h / 8;
    subtitle.w = 8 * subtitle.h;

    subtitle.x = (window_dimensions.w - subtitle.w) / 2;
    subtitle.y = 3 * (window_dimensions.h - subtitle.h) / 4;

    if (winner == player_0) {
        display_banner_pop_up(banner, "GG ez bleuh !", window, renderer);
        display_banner(banner, font, "big noobzz rouje..", subtitle, window, renderer);
    } else {
        display_banner_pop_up(banner, "GG ez rouje !", window, renderer);
        display_banner(banner, font, "big noobzz bleuh..", subtitle, window, renderer);
    }

    SDL_RenderPresent(renderer);

    TTF_CloseFont(font);
}