#ifndef DISPLAY_EFFECTS_H_
#define DISPLAY_EFFECTS_H_

#include <SDL2/SDL_render.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_video.h>
#include <stdbool.h>

#include "entity.h"

void display_banner(SDL_Texture * banner, TTF_Font * font, char * text, SDL_Rect banner_dest, SDL_Window * window, SDL_Renderer * renderer);
void display_banner_pop_up(SDL_Texture * banner, char * text, SDL_Window * window, SDL_Renderer * renderer);
void display_banner_side(SDL_Texture * banner, player_id curr_player, SDL_Window * window, SDL_Renderer * renderer);

void display_max_pieces(SDL_Texture * piece1, SDL_Texture * piece2, int x, int y, SDL_Window * window, SDL_Renderer * renderer);
void display_merge_pieces(SDL_Texture * piece1, SDL_Texture * piece2, int piece_winning, float frame, SDL_Window * window, SDL_Renderer * renderer);

void display_large_piece(SDL_Texture * piece, SDL_Window * window, SDL_Renderer * renderer);

void display_mlg(SDL_Texture * frame, SDL_Window * window, SDL_Renderer * renderer);

#endif