#include <SDL2/SDL_render.h>
#include <stdbool.h>

#include "display.h"
#include "textures.h"
#include "display_effects.h"

void display_banner(SDL_Texture * banner, TTF_Font * font, char * text, SDL_Rect banner_dest, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        txt_dest = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer
    
    // Affichage de la bannière

    SDL_QueryTexture(banner, NULL, NULL, &source.w, &source.h);

    SDL_RenderCopy(renderer, banner, &source, &banner_dest);

    if (text != NULL) {
        // Importation de la police
        
        SDL_Color color = {0, 0, 0, 255}; // Couleur du texte
        
        SDL_Texture * text_texture = NULL;

        // Affichage du texte

        text_texture = get_text_texture(text, font, color, window, renderer);

        SDL_QueryTexture(text_texture, NULL, NULL, &txt_dest.w, &txt_dest.h);

        txt_dest.x = banner_dest.x + (banner_dest.w - txt_dest.w) / 2;
        txt_dest.y = banner_dest.y + (banner_dest.h - txt_dest.h) / 2;

        SDL_RenderCopy(renderer, text_texture, NULL, &txt_dest);

        SDL_DestroyTexture(text_texture);   
    }
}

void display_banner_pop_up(SDL_Texture * banner, char * text, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_banner = {0},
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Ouverture de la police

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/GreatVibes-Regular.ttf", window_dimensions.h / 8);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    } 

    TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

    // Calcul des dimensions du texte

    SDL_Color color = {0, 0, 0, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    text_texture = get_text_texture(text, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);

    pos_txt.x = (window_dimensions.w - pos_txt.w) / 2;
    pos_txt.y = (window_dimensions.h - pos_txt.h) / 2;

    // Lecture des dimensions de la bannière

    SDL_QueryTexture(banner, NULL, NULL, &source.w, &source.h);

    pos_banner.w = 1.2 * pos_txt.w;
    pos_banner.h = 1.2 * pos_txt.h;

    pos_banner.x = (window_dimensions.w - pos_banner.w) / 2;
    pos_banner.y = (window_dimensions.h - pos_banner.h) / 2;

    // Affichage du texte

    SDL_RenderCopy(renderer, banner, &source, &pos_banner);
    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);

    TTF_CloseFont(font);
}

void display_banner_side(SDL_Texture * banner, player_id curr_player, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0},
        stash = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Dimensions de la zone d'affichage

    int length = 0.9 * window_dimensions.h; // Taille du plateau

    stash.w = (window_dimensions.w - length) / 2.0;
    stash.h = length / 8;

    stash.x = 0;
    stash.y = (window_dimensions.h - length / 8) / 2;

    char text[32];

    if (curr_player == player_0) {
        sprintf(text, "Joueur bleu, a vos ordres !");
    } else if (curr_player == player_1) {
        stash.x += stash.w + length + stash.x;
        sprintf(text, "Joueur rouge, a vos ordres !");
    }

    // Ouverture de la police

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/GreatVibes-Regular.ttf", stash.h / 2.5);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    } 

    TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

    display_banner(banner, font, text, stash, window, renderer);

    TTF_CloseFont(font);
}

void display_max_pieces(SDL_Texture * piece1, SDL_Texture * piece2, int x, int y, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0},
        destination = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);
    SDL_QueryTexture(piece1, NULL, NULL, &source.w, &source.h);

    // Affichage de la première pièce

    float zoom = 0.5 * window_dimensions.h / source.h; // Zoom de la pièce

    destination.w = source.w * zoom;
    destination.h = source.h * zoom;

    destination.x = 0.5 * window_dimensions.w - destination.w;
    destination.y = (window_dimensions.h - destination.h) / 2;

    int left_limit = 0.5 * window_dimensions.w - destination.w;
    int right_limit = 0.5 * window_dimensions.w + destination.w;

    if ((x >= left_limit) && (x <= right_limit) && (y >= destination.y) && (y <= destination.y + destination.h)) {
        SDL_SetTextureAlphaMod(piece1, 128);
        SDL_RenderCopy(renderer, piece1, &source, &destination);    
        SDL_SetTextureAlphaMod(piece1, 255);
    } else {
        SDL_RenderCopy(renderer, piece1, &source, &destination);
    }

    // Affichage de la deuxième pièce

    destination.x = 0.5 * window_dimensions.w;

    if ((x >= left_limit) && (x <= right_limit) && (y >= destination.y) && (y <= destination.y + destination.h)) {
        SDL_SetTextureAlphaMod(piece2, 128);
        SDL_RenderCopy(renderer, piece2, &source, &destination);    
        SDL_SetTextureAlphaMod(piece2, 255);
    } else {
        SDL_RenderCopy(renderer, piece2, &source, &destination);
    }
}

void display_merge_pieces(SDL_Texture * piece1, SDL_Texture * piece2, int piece_winning, float frame, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0},
        destination1 = {0},
        destination2 = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);
    SDL_QueryTexture(piece1, NULL, NULL, &source.w, &source.h);

    // Dimensions des 2 pièces

    float zoom = 0.5 * window_dimensions.h / source.h; // Zoom de la pièce

    destination1.w = source.w * zoom;
    destination1.h = source.h * zoom;
    destination1.y = (window_dimensions.h - destination1.h) / 2;

    destination2.w = destination1.w;
    destination2.h = destination1.h;
    destination2.y = destination1.y;

    // Placement des 2 pièces

    int init_destination1_x = 0.5 * window_dimensions.w - destination1.w;
    int init_destination2_x = 0.5 * window_dimensions.w;

    int final_destination_x = (window_dimensions.w - destination1.w) / 2;

    destination1.x = frame * final_destination_x + (1 - frame) * init_destination1_x;
    destination2.x = frame * final_destination_x + (1 - frame) * init_destination2_x;

    if (piece_winning == 1) {
        SDL_RenderCopy(renderer, piece2, &source, &destination2);
        SDL_RenderCopy(renderer, piece1, &source, &destination1);
    } else if (piece_winning == -1) {
        SDL_RenderCopy(renderer, piece1, &source, &destination1);
        SDL_RenderCopy(renderer, piece2, &source, &destination2);
    }
}

void display_large_piece(SDL_Texture * piece, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0},
        destination = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h);
    SDL_QueryTexture(piece, NULL, NULL, &source.w, &source.h);

    // Affichage de la première pièce

    float zoom = 0.3 * window_dimensions.h / source.h; // Zoom de la pièce

    destination.w = source.w * zoom;
    destination.h = source.h * zoom;

    destination.x = 0.05 * window_dimensions.w;
    destination.y = (window_dimensions.h - destination.h) / 2;

    SDL_RenderCopy(renderer, piece, &source, &destination);

    destination.x = 0.95 * window_dimensions.w - destination.w;

    SDL_RenderCopy(renderer, piece, &source, &destination);
}

void display_mlg(SDL_Texture * frame, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},
        window_dimensions = {0};

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre
    SDL_QueryTexture(frame, NULL, NULL, &source.w, &source.h); // Dimensions de l'image

    SDL_RenderCopy(renderer, frame, &source, &window_dimensions);
}