#ifndef DISPLAY_H_
#define DISPLAY_H_

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_render.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_video.h>

#include "board.h"
#include "entity.h"

#define ANIM_FRAMES 24.0

void highlight_tile(int r, int g, int b, int a, SDL_Rect rectangle, SDL_Renderer * renderer);

void display_piece(SDL_Texture * texture, board_t board, board_t moves, player_id curr_player,
                   coord_t coord, coord_t coord_selected, coord_t coord_hovered,
                   SDL_Window * window, SDL_Renderer * renderer);

void display_mlg(SDL_Texture * frame, SDL_Window * window, SDL_Renderer * renderer);

void display(SDL_Texture * table, SDL_Texture * background, SDL_Texture *** textures, SDL_Texture * banner, SDL_Texture * large_banner,
             board_t board, board_t moves,
             player_id curr_player, coord_t coord_selected, coord_t coord_hovered, player_t * player1, player_t * player2,
             bool positioning, bool ok_button_hovered, bool empty_stash, bool board_display,
             SDL_Window * window, SDL_Renderer * renderer);

// void move_piece(int, SDL_Texture *, piece_t, coord_t coord1, coord_t coord2, SDL_Window *, SDL_Renderer *);

void exit_sdl(char, char const *, SDL_Window *, SDL_Renderer *);

#endif