#ifndef BOARD_H
#define BOARD_H

#include "entity.h"
#include "list.h"

#define BOARD_SIZE 10
#define DEPLOYEMENT_ZONE_SIZE 4


typedef piece_t board_t[BOARD_SIZE][BOARD_SIZE];

void print_board(board_t board);

piece_t get_piece_from_coord(board_t board, coord_t coord);

void get_blank_board(board_t board);

void get_start_board(board_t board);

list_t * possible_moves_for_piece(coord_t coord, board_t board, list_t * list, player_t * player);

void get_highlight_board(board_t board, board_t new_board, coord_t coord, player_t * player);

void place_player1_piece_randomly(board_t board, player_t * player);

void highlight_possible_placements(board_t board,board_t new_board,player_t player);

void copy_board(board_t src, board_t dst);

bool_t take_move(board_t board, move_t move, player_t * attacking_player, player_t * defending_player, bool_t bypass_verif, int * result);

void place_piece_on_phase_drop(board_t available_move, board_t board, move_t move, player_t * player);

void change_placement_on_drop_phase(move_t move, board_t available_move, board_t board, player_t * player);

void undo_placement(board_t board,coord_t src, player_t * player);

list_t * possible_moves(board_t board, player_t * player);

bool_t is_player_loser(player_t player, board_t board);

int board_cmp(board_t board1, board_t board2);

#endif