#ifndef PLAYER_H_
#define PLAYER_H_

#include "piece.h"

typedef struct {
    int start_ticks;
    int paused_ticks;

    char paused;
    char started;
} timer_player_t;

typedef enum  {
    player_0,
    player_1,
    player_nil = -1,
} player_id;

typedef struct {
    player_id id;
    piece_t available_drop_piece[MAX_STASH_PIECE];
    timer_player_t timer;
} player_t;

timer_player_t create_timer();

void start_timer(timer_player_t *);
void stop_timer(timer_player_t *);
void pause_timer(timer_player_t *);
void unpause_timer(timer_player_t *);
int get_ticks(timer_player_t timer);

player_t * create_player();

int get_opposite_player_id(player_t player);

void add_drop_piece_to_player(player_t * player, piece_t piece);

void remove_drop_piece_to_player(player_t * player, piece_t piece);

#endif