#ifndef PIECE_H_
#define PIECE_H_

#define MAX_STASH_PIECE 10
#define PIECE_COUNT 9

typedef enum {
    move_nil,
    move_one,
    move_all,
} move_type;

typedef enum {
    blank,
    king, 
    rook, 
    bishop,
    gold_general,
    silver_general,
    knight,
    spear,
    pawn,
} piece_id;

typedef struct {
    piece_id id;
    char is_piece_promoted;
    char player_id; // (0 player du bas, 1 player du haut, 2 case vide)
} piece_t;

char is_piece_blank(piece_t piece);

char is_able_to_promote(piece_t piece);

void promote_piece(piece_t * piece);

piece_t swap_piece(piece_t piece);

piece_t get_blank_piece();

#endif