#include "piece.h"
#include "player.h"
#include <stdio.h>


piece_t get_blank_piece() {
    piece_t piece;
    piece.is_piece_promoted = 0;
    piece.id = blank;
    piece.player_id = player_nil;
    return piece;
}

/**
 * @brief Vérifie si une pièce est blank.
 * 
 * @param piece La pièce à vérifier.
 * @return char Retourne 1 si la pièce est blank, sinon 0.
 */
char is_piece_blank(piece_t piece) {
    return (piece.id == blank);
}

/**
 * @brief Vérifie si une pièce peut être promue.
 * 
 * @param piece La pièce à vérifier.
 * @return char Retourne 1 si la pièce peut être promue, sinon 0.
 */
char is_able_to_promote(piece_t piece) {
    if (is_piece_blank(piece) || piece.is_piece_promoted) {
        return 0;
    }

    if ((piece.id == gold_general) || (piece.id == king)) {
        return 0;
    }

    return 1;
}

/**
 * @brief Promeut une pièce si elle est éligible.
 * 
 * @param piece Pointeur vers la pièce à promouvoir.
 */
void promote_piece(piece_t * piece) {
    if (!is_able_to_promote(*piece)) {
        fprintf(stderr, "Tentative de promotion d'une pièce qui ne peut pas être promue !");
    } else {
        piece->is_piece_promoted = 1;
    }
}

/**
 * @brief Échange la pièce avec son opposée et réinitialise son état de promotion.
 * 
 * @param piece La pièce à échanger.
 * @return piece_t La pièce échangée.
 */
piece_t swap_piece(piece_t piece) {
    if (is_piece_blank(piece)) {
        fprintf(stderr, "Tentative de swap d'une pièce blank !");
    } else {
        piece.is_piece_promoted = 0;
        piece.player_id = 1 - piece.player_id;
    }
    return piece;
}