#include <stdio.h>
#include <stdlib.h>
#include "player.h"
#include "board.h"
#include "list.h"
#include "minmax.h"

char is_null_state(state_t * state){
    return (state == NULL);
}

void free_state(state_t * state){
    if (state != NULL){
        if (state->board != NULL){
            free_board(state->board);
        }
        free(state);
    }
    state = NULL;
}

state_t * minmax(board_t board,player_t act_player,player_t res_player,int depth){
    int i;
    list_t * list_of_sons;
    state_t * next_state;
    state_t * current_best_state = NULL;
    state_t * best_next_move = malloc(sizeof(state_t));
    if (depth == 0){
        best_next_move->quality = get_board_quality(act_player,res_player,board);
        best_next_move->act_player = act_player;
        best_next_move->res_player = res_player;
        best_next_move->board = copy_board(board);
    }
    else{
        list_of_sons = possible_moves(board,act_player);
        if(is_empty_list(list_of_sons)){
            fprintf(stderr,"Pas de coups légaux, minmax impossible");
        }
        else{
            for (i=0;i<(list_of_sons->length - 1);i++){
                next_state = minmax((list_of_sons->head->board),res_player,act_player,depth-1);
                if (is_null_state(current_best_state)){
                    current_best_state = next_state;
                    best_next_move->board = list_of_sons->head->board;
                    best_next_move->quality = get_board_quality(act_player, res_player, best_next_move->board);
                    best_next_move->act_player = act_player;
                    best_next_move->res_player = res_player;
                }
                else{
                    if (next_state->quality < current_best_state->quality){
                        free_state(current_best_state);
                        current_best_state = next_state;
                        best_next_move->board = list_of_sons->head->board;
                        best_next_move->quality = get_board_quality(act_player, res_player, best_next_move->board);
                        best_next_move->act_player = act_player;
                        best_next_move->res_player = res_player;
                    }
                    else{
                        free_state(next_state);
                    }
                }
                list_of_sons->head = list_of_sons->head->next;
                //print_board(best_next_move->board); //Pour déboggage
            }
        }
        
        free_list(list_of_sons);
    }
    
    return best_next_move;
}

state_t * get_minmax_move(board_t board, player_t * bot, player_t * opponent, int depth, coord_t * src, coord_t * dst) {
    int nb_piece_before = get_number_of_piece_in_board(board);
    state_t * moved_state = minmax(board, *bot, *opponent, depth);
    int nb_piece_after = get_number_of_piece_in_board(moved_state->board);

    if (nb_piece_after > nb_piece_before) { // Minmax à Drop
        src->x = -1;
        src->y = -1;
        *dst = get_dropped_piece(board, moved_state->board);
        remove_drop_piece_to_player(bot, get_piece_from_coords(moved_state->board, *dst));
    } else if (nb_piece_after < nb_piece_before) { // Minmax à Manger
        get_eaten_piece(board, moved_state->board, src, dst, *bot);
        add_drop_piece_to_player(bot, get_piece_from_coords(board, *dst));
    } else {
        get_moved_piece(board, moved_state->board, src, dst, *bot);
    }

    return moved_state;
}