#include "display.h"
#include <SDL2/SDL_rect.h>
#include <SDL2/SDL_render.h>
#include <SDL2/SDL_surface.h>
#include <SDL2/SDL_ttf.h>
#include "menu.h"

#define PLAYER_CHOICES 2
#define DIFFICULTY_CHOICES 4

void display_menu_title(char * txt, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Importation de la police

    SDL_Color color = {255, 255, 255, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    // Affichage du texte

    text_texture = get_text_texture(txt, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);

    pos_txt.x = (window_dimensions.w - pos_txt.w) / 2;
    pos_txt.y = window_dimensions.h / 16;

    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);
}

void display_victory_title(char num_winner, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Importation de la police

    TTF_Font * font = NULL;
    font = TTF_OpenFont("../fonts/Dosis-Bold.ttf", window_dimensions.h / 8);  // La police à charger, la taille désirée
    if (font == NULL) {
        exit_sdl(0, "Can't load font", window, renderer);
    } 

    TTF_SetFontStyle(font, TTF_STYLE_BOLD);

    SDL_Color color = {255, 255, 255, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    // Affichage du texte

    char text_victory[24];
    sprintf(text_victory, "Victoire du joueur %d", num_winner + 1);

    text_texture = get_text_texture(text_victory, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);

    pos_txt.x = (window_dimensions.w - pos_txt.w) / 2;
    pos_txt.y = (window_dimensions.h - pos_txt.h) / 2;

    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);
}

void display_menu_button_text(SDL_Rect * button, char * text, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        pos_txt = {0};          // Rectangle définissant où le texte doit être déposé dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Importation de la police

    SDL_Color color = {255, 255, 255, 255}; // Couleur du texte

    SDL_Texture * text_texture = NULL;

    // Affichage du texte

    text_texture = get_text_texture(text, font, color, window, renderer);

    SDL_QueryTexture(text_texture, NULL, NULL, &pos_txt.w, &pos_txt.h);
    
    pos_txt.x = button->x + (button->w - pos_txt.w) / 2;
    pos_txt.y = button->y + (button->h - pos_txt.h) / 2;

    SDL_RenderCopy(renderer, text_texture, NULL, &pos_txt);

    SDL_DestroyTexture(text_texture);
}

void display_menu_buttons(int x, int y, int nb_buttons, char ** txts, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        window_dimensions = {0}, // Rectangle définissant la fenêtre
        box = {0};       // Rectangle définissant où la zone source doit être déposée dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    box.w = 0.9 * window_dimensions.w / nb_buttons;
    box.h = 0.5 * window_dimensions.h;

    box.x = 0.025 * window_dimensions.w;
    box.y = 0.25 * window_dimensions.h;

    for (int i = 0; i < nb_buttons; ++i) {

        if ((x >= box.x) && (x <= box.x + box.w) && (y >= box.y) && (y <= box.y + box.h)) {
            SDL_SetRenderDrawColor(renderer, 0, 0, 0, 128);
        } else {
            SDL_SetRenderDrawColor(renderer, 0, 0, 0, 64);
        }

        SDL_RenderFillRect(renderer, &box);

        display_menu_button_text(&box, txts[i], font, window, renderer);

        box.x += 0.975 * window_dimensions.w / nb_buttons;
    }
}

void display_menu_background(SDL_Texture * background, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_Rect
        source = {0},               // Rectangle définissant la zone de la texture à récupérer
        window_dimensions = {0},    // Rectangle définissant la fenêtre
        destination = {0};          // Rectangle définissant où la zone source doit être déposée dans le renderer

    SDL_GetWindowSize(window, &window_dimensions.w, &window_dimensions.h); // Dimensions de la fenêtre

    // Affichage du fond

    SDL_QueryTexture(background, NULL, NULL, &source.w, &source.h);        // Dimensions de l'image

    destination = window_dimensions;

    SDL_RenderCopy(renderer, background, &source, &destination);
}

void display_menu(SDL_Texture * background, int x, int y, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    display_menu_background(background, window, renderer);
    display_menu_title("Mini Shogi", font, window, renderer);

    char ** txts = malloc(PLAYER_CHOICES * sizeof(char *));

    if (txts) {
        for (int i = 0; i < PLAYER_CHOICES; ++i) {
            txts[i] = malloc(16 * sizeof(char));
        }

        sprintf(txts[0], "1 joueur");
        sprintf(txts[1], "2 joueurs");

        display_menu_buttons(x, y, PLAYER_CHOICES, txts, font, window, renderer);

        SDL_RenderPresent(renderer);

        for (int i = 0; i < PLAYER_CHOICES; ++i) {
            free(txts[i]);
        }
        free(txts);
    }   
}

void display_menu_difficulty(SDL_Texture * background, int x, int y, TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    display_menu_background(background, window, renderer);
    display_menu_title("Difficulte", font, window, renderer);

    char ** txts = malloc(DIFFICULTY_CHOICES * sizeof(char *));

    if (txts) {
        for (int i = 0; i < DIFFICULTY_CHOICES; ++i) {
            txts[i] = malloc(16 * sizeof(char));
        }

        sprintf(txts[0], "Pion");
        sprintf(txts[1], "General");
        sprintf(txts[2], "Tour");
        sprintf(txts[3], "Roi");

        display_menu_buttons(x, y, DIFFICULTY_CHOICES, txts, font, window, renderer);

        SDL_RenderPresent(renderer);

        for (int i = 0; i < DIFFICULTY_CHOICES; ++i) {
            free(txts[i]);
        }
        free(txts);
    }    
}

void display_victory_menu(SDL_Texture * background, char num_winner, SDL_Window * window, SDL_Renderer * renderer) {
    SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
    SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND);
    SDL_RenderClear(renderer);

    display_menu_background(background, window, renderer);
    display_victory_title(num_winner, window, renderer);

    SDL_RenderPresent(renderer);
}