#ifndef LIST_H_
#define LIST_H_

#include "board.h"

typedef struct node{ //Noeud contenant un pointeur sur le board, et un sur le node suivant
    board_t board;
    struct node * next;
} node_t;

typedef struct list{ //Liste chaînée de board avec un pointeur sur sa fin
    int length;
    node_t * head;
    node_t * end;
} list_t;

char is_list_null(list_t * l); //Renvoie vrai si la liste est nulle
char is_empty_list(list_t * l); //Renvoie vrai si la liste est vide

char is_node_null(node_t * node); //Renvoie vrai si le node est nul

list_t * create_list(); // Alloue une nouvelle liste
list_t * list_merge(list_t *l, list_t * m); //Fusionne deux listes
list_t * list_add(list_t * l,board_t board); //Addition d'un board en tête de la liste

void free_list(list_t * l); //Libération d'une liste

list_t * possible_boards_from_piece(board_t board, player_t player, coord_t coord); //Donne la liste des coups possibles à partir d'une position de pièces

list_t * possible_moves(board_t board,player_t player);
#endif