#ifndef DISPLAY_H_
#define DISPLAY_H_

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_render.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_video.h>

#include "board.h"
#include "piece.h"
#include "player.h"
#include "utils.h"

#define SPRITE_W 8
#define SPRITE_H 4

#define ANIM_FRAMES 24.0

SDL_Texture * get_texture(char * file_image_name, SDL_Window * window, SDL_Renderer * renderer);
SDL_Texture * get_text_texture(char * text, TTF_Font * font, SDL_Color color, SDL_Window * window, SDL_Renderer * renderer);

void display(SDL_Texture * table, SDL_Texture * background, SDL_Texture * sprites, char checkerboard, char promote,
             coord_t coord_selected, coord_t coord_hovered, board_t board, board_t moves, int quality, player_t * player1, player_t * player2, player_t * curr_player,
             TTF_Font * font, SDL_Window * window, SDL_Renderer * renderer);

void move_piece(int, SDL_Texture *, piece_t, coord_t coord1, coord_t coord2, SDL_Window *, SDL_Renderer *);

void ask_promote(TTF_Font *, SDL_Window *, SDL_Renderer *);

void exit_sdl(char, char const *, SDL_Window *, SDL_Renderer *);

#endif