#ifndef BOARD_H_
#define BOARD_H_

#include "piece.h"
#include "player.h"
#include "utils.h"

#define BOARD_SIZE 5

typedef piece_t ** board_t;

void free_board(board_t board);

char is_move_taking_opponent_piece(board_t original_board, coord_t dst);

void print_board(board_t board);

board_t partial_copy_board(board_t board,coord_t coord);

piece_t get_piece_from_coords(board_t board, coord_t coords);

board_t get_board_by_array(int pieces_pos[BOARD_SIZE][BOARD_SIZE], char player_pos[BOARD_SIZE][BOARD_SIZE]);

board_t get_blank_board();

board_t get_start_board();

int get_board_quality(player_t act_player, player_t res_player, board_t board);

board_t get_all_possible_move_for_piece(player_t player, board_t board, coord_t coord);

char is_move_legal(board_t availables_moves, coord_t src, coord_t dest);

board_t copy_board(board_t original_board);

board_t take_move(board_t availables_moves, board_t original_board, player_t * current_player, 
    coord_t src, coord_t dst, char * is_needed_to_ask_for_promote, char * is_current_player_winner);

board_t get_all_possible_drop_for_piece(player_t player, board_t board, coord_t drop_index);

board_t get_all_possible_piece_slot(player_t player, board_t board, coord_t coord);

int get_number_of_piece_in_board(board_t board);

char is_game_over(board_t board);

void get_eaten_piece(board_t prev_board,board_t new_board,coord_t * coord_src, coord_t * coord_dst, player_t player);

coord_t get_dropped_piece(board_t prev_board,board_t new_board);

void get_moved_piece(board_t prev_board,board_t new_board, coord_t * coord_src, coord_t * coord_dst, player_t player);

#endif