```c
is_valid_move(player_t, board_t, int original_x, int original_y, int new_x, int new_y)
move_piece(player_t, board_t, int original_x, int original_y, int new_x, int new_y)

is_valid_drop(player_t, board_t, int original_x, int original_y, int new_x, int new_y)
drop_piece(player_t, board_t, int original_x, int original_y, int new_x, int new_y)

is_player_winner(player_t)
add_move_to_board_history(player_t, board_t)
export_move_history(player_t)

struct player_t :
    int time_remaining
    int id
    pq available_drop_piece[NBpieceTotal-1]

    get_player_time()
    remove_time()
    add_time()
    reset_time()

    add_drop_piece()
    remove_drop_piece()

struct board_t :
    piece_t content[5][5]

    get_board_quality()

enum piece_quality :
    blank = 0
    pawn = 1
    silver_general = 4
    gold_general = 6
    bishop = 8
    rook = 10
    promoted_bishop = 12
    promoted_rook = 12
    king = 1000

struct piece_t :
    pq original_value (= blank ssi case vide)
    pq promoted_value (= blank ssi non promu)
    char player_id (0 player du bas, 1 player du haut, 2 case vide)

    is_piece_blank()
    is_piece_promoted()
    
    get_piece_value()

    is_able_to_promote()
    promote_piece()


Promoted rook :
[ 0][ 0][ 0]
[ 1][-1][ 1]
[-1][ 0][-1]
[ 1][-1][ 1]
typedef int[4][3] piece_move_t;
typedef board_t[500] board_history_t;
```