#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>

SDL_Texture * load_texture_from_image(char * file_image_name, SDL_Renderer * renderer){
    SDL_Surface * my_image = NULL;           // Variable de passage
    SDL_Texture * my_texture = NULL;         // La texture

    my_image = IMG_Load(file_image_name);   // Chargement de l'image dans la surface
                                            // image=SDL_LoadBMP(file_image_name); fonction standard de la SDL, 
                                            // uniquement possible si l'image est au format bmp */
    if (my_image == NULL){
        printf("Chargement de l'image impossible\n");
        SDL_Quit();
    }
    my_texture = SDL_CreateTextureFromSurface(renderer, my_image); // Chargement de l'image de la surface vers la texture
    SDL_FreeSurface(my_image);                                     // la SDL_Surface ne sert que comme élément transitoire 
    if (my_texture == NULL){ 
        printf("Chargement de la texture impossible\n");
        SDL_Quit();
    }
    return my_texture;
}

int animation(){
    SDL_Window * window;
    SDL_DisplayMode mode;
    SDL_Renderer * render;
    SDL_bool program_on = SDL_TRUE, paused = SDL_FALSE, event_utile = SDL_FALSE;
    SDL_Event event;
    SDL_Texture * texture_layers[8];
    SDL_Texture * texture_tab[8];
    int i,j,k;
    char nom_fichier[255];
    int scr_width,scr_height;
    float decalage[8] = {0.};
    float zoom = 1;
    SDL_GetCurrentDisplayMode(0,&mode);
    scr_width = mode.w;
    scr_height = mode.h-75;
    (void) event;
    (void) event_utile;
    (void) program_on;
    (void) paused;

    //Création de la window

    window = SDL_CreateWindow(
       "YEEEEEEEEET",
       0, 0,                                 
       scr_width,scr_height,               
       SDL_WINDOW_RESIZABLE);
    if (window == NULL){
            SDL_Log("Error : SDL window creation - %s\n",SDL_GetError()); //Message d'erreur     
            SDL_Quit(); //Fermeture SDL                         
            exit(EXIT_FAILURE);
    }


    //Création du renderer
    render = SDL_CreateRenderer(window, -1,
                     SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);
    if (render == NULL){
        printf("Render déficient \n"); //On quitte
        SDL_Quit();
    };
    SDL_RenderPresent(render);
     
    //Stockage des dimensions
    SDL_Rect 
        source = {0},
        source_personnage = {0},
        window_dimensions = {0},
        destination_perso = {0}
    ;

    SDL_Rect destination_layers[8][2];

    //Création des textures
    for (i=0;i<8;i++){
        sprintf(nom_fichier,"./Layers/%d.png",i+1);
        texture_layers[i] = load_texture_from_image(nom_fichier,render);
    }

    //texture = load_texture_from_image("Paysage_montagne_bleue.jpg",render);

    for (i=0;i<4;i++){
        sprintf(nom_fichier,"Player_Walk_Special_%d.png",i);
        texture_tab[i] = load_texture_from_image(nom_fichier,render);
        sprintf(nom_fichier,"Player_Attack_Special_%d.png",i);
        texture_tab[4+i] = load_texture_from_image(nom_fichier,render);
    }

    SDL_GetWindowSize(window, &window_dimensions.w,&window_dimensions.h);

    //Récupération du format des layers

    SDL_QueryTexture(texture_layers[0], NULL, NULL,&source.w, &source.h);

    //Récupération du format du personnage
    SDL_QueryTexture(texture_tab[0],NULL,NULL,&source_personnage.w,&source_personnage.h);
    destination_perso = window_dimensions;
    for (i=0;i<8;i++){
        for (k=0;k<2;k++){
        destination_layers[i][k] = window_dimensions;
        }
    }

    //Zoom du personnage

    destination_perso.h = source_personnage.h * zoom;
    destination_perso.w = source_personnage.w * zoom;


    SDL_RenderCopy(render,texture_layers[0],&source,&destination_layers[0][0]);
    SDL_RenderPresent(render);
    j = 0;
    
    //Boucle du programme
    while (program_on) {
        event_utile = SDL_FALSE;
        while(!event_utile && SDL_PollEvent(&event)){
            switch (event.type) {
                case SDL_QUIT:
                    program_on = SDL_FALSE;
                    event_utile = SDL_TRUE;
                    break;
                case SDL_KEYDOWN:
                    switch (event.key.keysym.sym) {
                        case SDLK_p:
                        case SDLK_SPACE:
                            paused = !paused;
                            event_utile = SDL_TRUE;
                            break;
                        case SDLK_ESCAPE:
                        case SDLK_q:
                            program_on = 0;
                            event_utile = SDL_TRUE;
                            break;
                        default:
                            break;
                    }
                default:
                    break;
            }
        }
        //Création du nouveau render
        SDL_RenderClear(render);
        for (i=0;i<8;i++){
            decalage[i] += i*scr_width/2000.;
            if (decalage[i] > scr_width){
                decalage[i] -= scr_width;
            }
            destination_layers[i][0].x = scr_width - decalage[i];
            destination_layers[i][1].x = 0 - decalage[i];
            for (k=0;k<2;k++){
            SDL_RenderCopy(render,texture_layers[i],&source,&destination_layers[i][k]);
            }
        }
        destination_perso.x = scr_width/2 - source_personnage.w/2;
        destination_perso.y = 3*scr_height/4;
        SDL_RenderCopy(render,texture_tab[(j/4)%8],&source_personnage,&destination_perso);
        SDL_RenderPresent(render);
        j++;
        SDL_Delay(50);
        
    }
    SDL_RenderClear(render);
    SDL_DestroyRenderer(render);
    SDL_DestroyWindow(window);
    IMG_Quit();
    SDL_Quit();
    return 0;
}