#include <stdio.h>
#include <stdlib.h>
#include <SDL2/SDL.h>
#include <math.h>
#include <time.h>
#include "pave.h"

int trace_triangle(SDL_Renderer * renderer, int x, int y, int w, float theta){
    //Dessine un triangle
    SDL_SetRenderDrawColor(renderer,255,0,0,SDL_ALPHA_OPAQUE);
    SDL_RenderDrawLine(renderer, x, y, x + w * cos(theta), y + w * sin(theta));
	SDL_RenderDrawLine(renderer, x + w * cos(theta), y + w * sin(theta), x + w * cos(theta) + w * cos(2 * M_PI/3 + theta), y + w * sin(theta) + w * sin(2 * M_PI/3 + theta));
	SDL_RenderDrawLine(renderer, x + w * cos(theta)+ w * cos(2 * M_PI/3 + theta), y + w * sin(theta)+w * sin(2 * M_PI/3 + theta), x, y);
    return 0;
}

struct vecteur_t * calcul_nv_coordonnees(int x,int y, int x_crs, int y_crs){
    struct vecteur_t * mid;
    struct vecteur_t * res;
    mid = malloc(sizeof(struct vecteur_t));
    res = malloc(sizeof(struct vecteur_t));
    mid->x = x_crs - x;
    mid->y = y_crs - y;
    res->x = (10*mid->x)/(sqrt(pow((mid->x),2) + pow((mid->y),2)));
    res->y = (10*mid->y)/(sqrt(pow((mid->x),2) + pow((mid->y),2)));
    return res;
}

int petites_cellules(){
    SDL_Window * window;
    SDL_DisplayMode mode;
    SDL_Renderer * render;
    SDL_bool program_on = SDL_TRUE, paused = SDL_FALSE, event_utile = SDL_FALSE;
    SDL_Event event;
    int i;
    int scr_width,scr_height;
    int x_triangle[10]; //Coordonnées x des triangles
    int y_triangle[10]; //Coordonnées y des triangles
    struct vecteur_t * direction; //Stockage du vecteur direction vers la souris
    direction = malloc(sizeof(struct vecteur_t));
    int x_crs, y_crs; //Stockage de l'état de la souris
    float theta_triangle[10]; //Angle de rotation des triangles
    srand(time(NULL)); //Seed
    //Récupérer le display
    SDL_GetCurrentDisplayMode(0,&mode);
    scr_width = mode.w;
    scr_height = mode.h-75;

    //Ouverture de la fenêtre
    window = SDL_CreateWindow(
       "SPORE V0.0.01",
       0, 0,                                 
       scr_width,scr_height,               
       SDL_WINDOW_RESIZABLE);
    if (window == NULL){
            SDL_Log("Error : SDL window creation - %s\n",SDL_GetError()); //Message d'erreur     
            SDL_Quit(); //Fermeture SDL                         
            exit(EXIT_FAILURE);
    }

    //Création des coordonnées des triangles

    for (i=0;i<10;i++){
        x_triangle[i] = rand()%1800;
        y_triangle[i] = rand()%1000;
    }
    
    theta_triangle[0] = 0;
    theta_triangle[1] = M_PI/6;
    theta_triangle[2] = M_PI/4;
    theta_triangle[3] = M_PI/3;
    theta_triangle[4] = M_PI/2;
    theta_triangle[5] = M_PI;
    theta_triangle[6] = - 1 * M_PI/6;
    theta_triangle[7] = - 1 * M_PI/4;
    theta_triangle[8] = - 1 * M_PI/3;
    theta_triangle[9] = - 1 * M_PI/2;

    //Création du renderer
    render = SDL_CreateRenderer(window, -1,
                     SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);
    if (render == NULL){
        printf("Render déficient \n"); //On quitte
        SDL_Quit();
    };
    SDL_RenderPresent(render);

    while (program_on) {
        event_utile = SDL_FALSE;
        while(!event_utile && SDL_PollEvent(&event)){
            switch (event.type) {
                case SDL_QUIT:
                    program_on = SDL_FALSE;
                    event_utile = SDL_TRUE;
                    break;
                case SDL_KEYDOWN:
                    switch (event.key.keysym.sym) {
                        case SDLK_p:
                        case SDLK_SPACE:
                            paused = !paused;
                            event_utile = SDL_TRUE;
                            break;
                        case SDLK_ESCAPE:
                        case SDLK_q:
                            program_on = 0;
                            event_utile = SDL_TRUE;
                            break;
                        case SDLK_n:
                            event_utile = SDL_TRUE;
                            SDL_SetRenderDrawColor(render,0,0,0,SDL_ALPHA_OPAQUE);
                            SDL_RenderClear(render);
                        default:
                            break;
                    }
                default:
                    break;
            }

        }
        SDL_GetMouseState(&x_crs,&y_crs);
        for (i=0;i<10;i++){
            direction = calcul_nv_coordonnees(x_triangle[i],y_triangle[i],x_crs,y_crs);
            x_triangle[i] = x_triangle[i] + direction->x;
            y_triangle[i] = y_triangle[i] + direction->y;
            trace_triangle(render,x_triangle[i],y_triangle[i],50,theta_triangle[i]);
        }
        SDL_RenderPresent(render);
        SDL_Delay(50);
    }
    SDL_RenderPresent(render);
    SDL_Delay(50);
    SDL_DestroyRenderer(render);
    SDL_DestroyWindow(window);

    return 0;

}