#include <SDL2/SDL.h>
#include <SDL2/SDL_events.h>
#include <SDL2/SDL_log.h>
#include <SDL2/SDL_render.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

typedef struct {
   int x;
   int y;
   int value;
} valpoint_t;

typedef struct {
    char up;
    char down;
    char left;
    char right;
} arrow_t;

void end_sdl(char ok, char const *msg, SDL_Window *window, SDL_Renderer *renderer) {
    char msg_formated[255];
    int l;

    if (!ok) {
        strncpy(msg_formated, msg, 250);
        l = strlen(msg_formated);
        strcpy(msg_formated + l, " : %s\n");

        SDL_Log(msg_formated, SDL_GetError());
    }

    if (renderer != NULL) {
        SDL_DestroyRenderer(renderer);
        renderer = NULL;
    }
    if (window != NULL) {
        SDL_DestroyWindow(window);
        window = NULL;
    }

    SDL_Quit();

    if (!ok) {
        exit(EXIT_FAILURE);
    }
}

void draw_square(SDL_Renderer *renderer, int r, int g, int b, int x, int y, int size) {
    SDL_Rect rect;
    rect.x = x;
    rect.y = y;
    rect.w = size;
    rect.h = size;

    SDL_SetRenderDrawColor(renderer, r, g, b, 255);
    SDL_RenderFillRect(renderer, &rect);
}

void draw(SDL_Renderer *renderer, valpoint_t player, valpoint_t food) {

    // Fond
    SDL_SetRenderDrawColor(renderer, 19, 0, 26, 255); 
    SDL_RenderClear(renderer);
    
    // Dessin joueur
    const int shadow_scale = player.value/40;
    draw_square(renderer, 0, 0, 150, player.x-shadow_scale, player.y-shadow_scale, player.value+shadow_scale);
    draw_square(renderer, 0, 0, 255, player.x, player.y, player.value);


    // Dessin nourriture
    draw_square(renderer, 255, 0, 0, food.x, food.y, food.value/10);
}

void game_logic(arrow_t dir, valpoint_t* player, valpoint_t *food, valpoint_t dim_window) {
    const int speed = 10;

    // La valeur de player.value correspond à sa taille
    // La valeur de food.value correspond à son temps de vie restant

    // Déplacement du joueur
    if (dir.up && (player->y > 0)) player->y -= speed; else if (dir.up) player->y = 0;
    if (dir.down && (player->y < dim_window.y - player->value)) player->y += speed; else if (dir.down) player->y = dim_window.y - player->value;
    if (dir.left && (player->x > 0)) player->x -= speed; else if (dir.left) player->x = 0;
    if (dir.right && (player->x < dim_window.x - player->value)) player->x += speed; else if (dir.right) player->x = dim_window.x - player->value;

    // Gestion collision avec la nouriture
    char collision = 0;
    int player_xmax = player->x + player->value;
    int player_ymax = player->y + player->value;
    if ((food->x > player->x) && (food->x < player_xmax) && (food->y > player->y) && (food->y < player_ymax)) {
        collision = 1;
        if (player->value < 300) {
            player->value += 10;
        }
    }

    // Génération nourriture
    if ((0 == food->value) || collision) {
        food->value = 255;
        food->x = rand()%dim_window.x;
        food->y = rand()%dim_window.y;
    } else {
        food->value -= 1;
    }

    // Décroissance naturelle du joueur
    const int decrease_rate = 1;
    if ((player->value - decrease_rate > 20) && (rand()%10 == 0)) {
        player->value -= decrease_rate;
    }
}


int main(int argc, char **argv) {
    (void)argc;
    (void)argv;

    srand(time(NULL));

    SDL_Window *window = NULL;
    SDL_Renderer *renderer = NULL;

    SDL_DisplayMode screen;

    if (SDL_Init(SDL_INIT_VIDEO) != 0) {
        end_sdl(0, "ERROR SDL INIT", window, renderer);
    }

    SDL_GetCurrentDisplayMode(0, &screen);


    valpoint_t dim_window;
    dim_window.x = screen.w * 0.66;
    dim_window.y = screen.h * 0.66;

    window = SDL_CreateWindow("Miam Miam", SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, dim_window.x, dim_window.y, SDL_WINDOW_OPENGL);
    if (window == NULL) {
        end_sdl(0, "ERROR WINDOW CREATION", window, renderer);
    }

    renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);
    if (renderer == NULL) {
        end_sdl(0, "ERROR RENDERER CREATION", window, renderer);
    }



    arrow_t dir = {0, 0, 0, 0};
    
    valpoint_t player;
    player.x = dim_window.x / 2;
    player.y = dim_window.y / 2;
    player.value = 20;

    valpoint_t food;
    food.value = 0;

    SDL_Event event;
    char running = 1;
    while (running) {
        while (SDL_PollEvent(&event)) {
            switch (event.type) {
                case SDL_QUIT:
                    running = 0;
                    break;
                case SDL_KEYDOWN:
                    switch (event.key.keysym.sym) {
                        case SDLK_UP:
                            dir.up = 1;
                            break;
                        case SDLK_DOWN:
                            dir.down = 1;
                            break;
                        case SDLK_LEFT:
                            dir.left = 1;
                            break;
                        case SDLK_RIGHT:
                            dir.right = 1;
                            break;
                    }
                    break;
                case SDL_KEYUP:
                    switch (event.key.keysym.sym) {
                        case SDLK_UP:
                            dir.up = 0;
                            break;
                        case SDLK_DOWN:
                            dir.down = 0;
                            break;
                        case SDLK_LEFT:
                            dir.left = 0;
                            break;
                        case SDLK_RIGHT:
                            dir.right = 0;
                            break;
                    }
                    break;
            }
        }

        game_logic(dir, &player, &food, dim_window);
        draw(renderer, player, food);             
        SDL_RenderPresent(renderer);
        SDL_Delay(10);
    }

    end_sdl(1, "Normal ending", window, renderer);
    return EXIT_SUCCESS;
}
