#include <SDL2/SDL.h>
#include <stdio.h>

int main(int argc, char ** argv) {
    (void) argc;
    (void) argv;

    SDL_Window * window_1 = NULL;
    SDL_Window * window_2 = NULL;

    // Initialisation de la SDL & Gestion des échecs

    if (SDL_Init(SDL_INIT_VIDEO) != 0) {
        SDL_Log("Erreur d'initialisation de SDL : %s\n", SDL_GetError());
    }

    window_1 = SDL_CreateWindow(
        "Fenêtre à gauche",         // Nom de la fenêtre
        0, 0,                       // Position du coin supérieur gauche de la fenêtre
        400, 300,                   // Largeur, Hauteur
        SDL_WINDOW_RESIZABLE        // Fenêtre redimensionnable
    );

    if (!window_1) {
        SDL_Log("Erreur lors de la création de la fenêtre 1 : %s\n", SDL_GetError());
        SDL_Quit();
        exit(EXIT_FAILURE);
    }

    window_2 = SDL_CreateWindow(
        "Fenêtre à droite",         // Nom de la fenêtre
        400, 0,                     // Position du coin supérieur gauche de la fenêtre
        500, 300,                   // Largeur, Hauteur
        0                          // Fenêtre redimensionnable
    );

    if (!window_2) {
        SDL_Log("Erreur lors de la création de la fenêtre 2 : %s\n", SDL_GetError());
        SDL_DestroyWindow(window_1); // Il faut aussi détruire la fenêtre 1
        SDL_Quit();
        exit(EXIT_FAILURE);
    }

    /* Normalement, on devrait ici remplir les fenêtres... */
    SDL_Delay(2000);                           // Pause exprimée  en ms

    /* et on referme tout ce qu'on a ouvert en ordre inverse de la création */
    SDL_DestroyWindow(window_2);               // la fenêtre 2  
    SDL_DestroyWindow(window_1);               // la fenêtre 1     

    SDL_Quit();                                // la SDL

    return 0;
}
