#include <SDL2/SDL.h>
#include <stdio.h>
#include <math.h>

#define NB_WIN 4
#define SIZE_WIN 100
#define PI 3.14159265358979323846


int main(int argc, char ** argv) {
    (void) argc;
    (void) argv;

    int i, j;

    /* Initialisation des fenêtres */

    SDL_Window ** windows = malloc(NB_WIN * sizeof(SDL_Window *));

    if (windows) {
        for (i = 0; i < NB_WIN; ++i) {
            windows[i] = NULL;
        }
    }

    // Initialisation de la SDL & Gestion des échecs

    if (SDL_Init(SDL_INIT_VIDEO) != 0) {
        SDL_Log("Erreur d'initialisation de SDL : %s\n", SDL_GetError());
    }

    // Coordonnées du milieu de l'écran

    SDL_DisplayMode mode;

    SDL_GetCurrentDisplayMode(0, &mode);

    int mid_x = mode.w / 2;
    int mid_y = mode.h / 2;
    
    // On veut tracer un cercle.
    // On utilise des coordonnées polaires.

    double radius = mode.w / 5;
    double angle = 0;

    // Coordonnées cartésiennes de la fenêtre

    int x;
    int y;

    fprintf(stderr, "%d - %d\n", mode.h, mode.w);

    for (i = 0; i < NB_WIN; ++i) {
        // Conversion en coordonnées cartésiennes
        x = mid_x + (radius * cos(angle)) - (SIZE_WIN / 2);
        y = mid_y + (radius * sin(angle)) - (SIZE_WIN / 2);

        // Ouverture de la fenêtre
        windows[i] = SDL_CreateWindow(
            "Circle",                   // Nom de la fenêtre
            x, y,                       // Position du coin supérieur gauche de la fenêtre
            SIZE_WIN, SIZE_WIN,         // Largeur, Hauteur
            SDL_WINDOW_RESIZABLE        // Fenêtre redimensionnable
        );

        if (windows[i] == NULL) {
            for (j = 0; j < i; ++j) {
                SDL_Log("Error when creating the circle of windows : %s\n", SDL_GetError());
                SDL_DestroyWindow(windows[i]);
                SDL_Quit();
                exit(EXIT_FAILURE);
            }
        }

        // Augmentation de l'angle
        angle += 2 * PI / NB_WIN;
    }


    /* Boucle d'événements : Remplissage des fenêtres */

    SDL_bool program_on = SDL_TRUE;               
    SDL_Event event;       

    SDL_Renderer * renderer;

    int iter = 0;

    while (program_on && iter < 100) {
        // Gestion des événements

        if (SDL_PollEvent(&event)) {
            switch(event.type) {

                case SDL_QUIT:
                    program_on = SDL_FALSE;
                    break;

                case SDL_KEYDOWN:
                    switch (event.key.keysym.sym) {  
      
                        case SDLK_SPACE:                            
                            program_on = SDL_FALSE;
                            break;

                        default:
                            break;
                    
                    }


                default:
                    break;

            }
        }

        // Remplissage des fenêtres

        angle += PI / 64;

        SDL_Rect rectangle;
        rectangle.w = SIZE_WIN;
        rectangle.h = SIZE_WIN;
        rectangle.x = 0;
        rectangle.y = 0;

        for (i = 0; i < NB_WIN; ++i) {
            renderer = SDL_CreateRenderer(windows[i], -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);

            if (renderer != NULL) {
                // Déplacement de la fenêtre

                x = mid_x + (radius * cos(angle)) - (SIZE_WIN / 2);
                y = mid_y + (radius * sin(angle)) - (SIZE_WIN / 2);

                SDL_SetWindowPosition(windows[i], x, y);

                // Coloriage de la fenêtre

                SDL_SetRenderDrawColor(renderer, x * 255 / mode.w, y * 255 / mode.h, iter % 255 / mode.w, 255);

                SDL_RenderFillRect(renderer, &rectangle);
                SDL_RenderPresent(renderer);

                // Mémoire rendue pour le prochain rendu

                SDL_DestroyRenderer(renderer);
                renderer = NULL;
            }

            // Augmentation de l'angle
            angle += 2 * PI / NB_WIN;
        }

        SDL_Delay(50);

        ++iter;
    }

    /* Fermeture des fenêtres */

    for (i = 0; i < NB_WIN; ++i) {
        SDL_DestroyWindow(windows[i]);
    }

    free(windows);  

    SDL_Quit();

    return 0;
}
