#include <SDL2/SDL.h>
#include <stdio.h>


int creer_fenetre(){
    SDL_Window ** window_tab = malloc(20*sizeof(SDL_Window *));
    SDL_DisplayMode mode; //Pour récupérer le display
    SDL_Renderer ** render_tab = malloc(20*sizeof(SDL_Renderer *));
    int i,j,scr_width,scr_height;

    //Récupérer le display
    SDL_GetCurrentDisplayMode(0,&mode);
    scr_width = mode.w;
    scr_height = mode.h-75;

    printf("%d %d\n",scr_width,scr_height);

    for (i=0;i<10;i++){
        window_tab[i] = SDL_CreateWindow(
       "Fenêtre POG",
       0+i*(scr_width/10), 0+i*(scr_height/10),                                 
       (scr_width/10),(scr_height/10),                            
       SDL_WINDOW_RESIZABLE);
        if (window_tab[i] == NULL){
            SDL_Log("Error : SDL window %d creation - %s\n",i,SDL_GetError()); //Message d'erreur     
            SDL_Quit(); //Fermeture SDL                         
            exit(EXIT_FAILURE);
        }
        render_tab[i] = SDL_CreateRenderer(window_tab[i], -1,
                     SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);
        if (render_tab[i] == NULL){
            printf("Render %d déficient \n",i); //On quitte
            SDL_Quit();
        };
        SDL_RenderPresent(render_tab[i]);
    }
    for (i=0;i<10;i++){
        window_tab[i+10] = SDL_CreateWindow(
       "Fenêtre POG",
       0+i*(scr_width/10), (scr_height)-(i+1)*(scr_height/10),                                 
       (scr_width/10),(scr_height/10),                            
       SDL_WINDOW_RESIZABLE);
        if (window_tab[i] == NULL){
            SDL_Log("Error : SDL window %d creation - %s\n",i,SDL_GetError()); //Message d'erreur     
            SDL_Quit(); //Fermeture SDL                         
            exit(EXIT_FAILURE);
        }
        render_tab[i+10] = SDL_CreateRenderer(window_tab[i+10], -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC);
        if (render_tab[i] == NULL) {
            printf("Render %d déficient \n",i); 
            SDL_Quit(); // On quitte
        SDL_RenderPresent(render_tab[i+10]);
        }
    }

    for (j=9;j>=3;j--){
        SDL_DestroyRenderer(render_tab[j]);
        SDL_DestroyWindow(window_tab[j]);
        SDL_DestroyRenderer(render_tab[10+j]);
        SDL_DestroyWindow(window_tab[10+j]);
        for (i=0;i<j;i++){
            SDL_SetWindowPosition(window_tab[i],0+i*(scr_width/j), 0+i*(scr_height/j));
            SDL_SetWindowPosition(window_tab[i+10],0+i*(scr_width/j), (scr_height)-(i+1)*(scr_height/j));
            SDL_Delay(100);
            SDL_SetWindowSize(window_tab[i],(scr_width/j),(scr_height/j));
            SDL_SetWindowSize(window_tab[i+10],(scr_width/j),(scr_height/j));
            SDL_Delay(100);
            SDL_RenderPresent(render_tab[i]);
            SDL_RenderPresent(render_tab[i+10]);
        }
    }

    SDL_Delay(2500);

    for (j=0;j<3;j++){
        SDL_DestroyWindow(window_tab[j]);
        SDL_DestroyWindow(window_tab[j+10]);
    }
    SDL_Quit();
    free(window_tab);
    free(render_tab);
    return 0;
}
