#include <SDL2/SDL.h>
#include <stdio.h>
#include <string.h>

#define WIN_NB 9

int main(int argc, char **argv) {
    (void)argc;
    (void)argv;

    SDL_Window ** windows = malloc(WIN_NB*sizeof(SDL_Window *));
    
    /* Initialisation de la SDL  + gestion de l'échec possible */
    if (SDL_Init(SDL_INIT_VIDEO) != 0) {
    SDL_Log("Error : SDL initialisation - %s\n", 
                SDL_GetError());                // l'initialisation de la SDL a échoué 
    exit(EXIT_FAILURE);
    }

    // Récupération de la dimension de l'écran
    SDL_DisplayMode display;
    if (SDL_GetCurrentDisplayMode(0, &display)) {
        exit(EXIT_FAILURE);
    }

    int h_window = (display.h-80)/9;
    int w_window = 400;

    for (int i = 0; i<WIN_NB; i++) {
        /* Création de la fenêtre de gauche */
        char window_name[20];
        sprintf(window_name, "Fenêtre %d", i+1);
    
        windows[i] = SDL_CreateWindow(
        window_name,                    // codage en utf8, donc accents possibles
        0, h_window*i,                                  // coin haut gauche en haut gauche de l'écran
        w_window, h_window,                              // largeur = 400, hauteur = 300
        SDL_WINDOW_RESIZABLE);                 // redimensionnable

        if (windows[i] == NULL) {
        SDL_Log("Error : SDL window %d creation - %s\n", 
                    i, SDL_GetError());                 // échec de la création de la fenêtre
        
        for (int j = 0; j<i; j++) {
            SDL_DestroyWindow(windows[j]);
        }
        SDL_Quit();                              // On referme la SDL       
        exit(EXIT_FAILURE);
        }
    }

    // Déplacement des fenêtres

    int x;
    int y;
    int reverse[WIN_NB];
    int speed = 2;
    int flat_speed = 10;
    for (int nb_iter = 0; nb_iter < 150; nb_iter++) {
        for (int i = 0; i<WIN_NB; i++) {
            SDL_GetWindowPosition(windows[i], &x, &y);

            int delta = (i+flat_speed)*speed;

            if (x+delta >= display.w-w_window){
                reverse[i] = 1;
            } else {
                if (x-delta < 0) {
                    reverse[i] = 0;
                }
            }

            int new_x;
            if (reverse[i]) {
                new_x = x-delta;
            } else {
                new_x = x+delta;
            }
            SDL_SetWindowPosition(windows[i], new_x, h_window*i);
        }
    }

    /* et on referme tout ce qu'on a ouvert en ordre inverse de la création */
    for (int i = 0; i<WIN_NB; i++) {
        SDL_DestroyWindow(windows[i]);
    }

    free(windows);
    SDL_Quit();

    return 0;
}