<#ftl encoding="utf-8">
<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">

<div class="content">
     <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

        <h1>Liste des dresseurs</h1>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Prénom Nom</th>
                    <th>Identifiant</th>
                    <th>Dernière connexion</th>
                    <th>Nombre de mises à jour restantes</th>
                </tr>
            </thead>
            <#list users as user>
            <tr class="data-row">
                <td><a href="/users/${user.id}">${user.id}</a></td>
                <td>${user.firstName} ${user.lastName}</td>
                <td><a href="/users/${user.id}">${user.identifier}</a></td>
                <td>${user.lastConnection}</td>
                <td>${user.nbUpgrades}</td>
            </tr>
            </#list>
        </table>

        <#if users?size == 0>
            <p>Aucun dresseur n'est encore inscrit. Mais cela ne saurait tarder !</p>
        </#if>
    </#if>
</div>
</body>
</html>