<#ftl encoding="utf-8">

<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">
<div class="content">

    <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

        <h1>Dresseur numéro ${user.id} - ${user.identifier} -</h1>

        <hr>
        <h1>Liste de ses Pokémons</h1>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Surnom</th>
                    <th>Niveau</th>
                </tr>
            </thead>
            <#list pokemons as pokemon>
            <tr class="data-row">
                <td><a href="/pokemons/${pokemon.id}">${pokemon.id}</a></td>
                <td>${pokemon.species.name}</td>
                <td><a href="/pokemons/${pokemon.id}">${pokemon.nickname}</a></td>
                <td>${pokemon.level}</td>
            </tr>
        </#list>
        </table>
        <#if pokemons?size == 0>
            <p>Ce dresseur n'a pas encore de Pokémon.</p>
            <!--Théoriquement impossible -->
        </#if>
    </#if>

</div>

</body>

</html>
