<#ftl encoding="utf-8">

<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">
<div class="content">

    <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

    <h1>Caractéristiques du Pokémon numéro ${pokemon.id} (${pokemon.nickname}) de ${pokemon.owner.firstName} ${pokemon.owner.lastName}</h1>
    <hr>

    <div class="informations">
        
        <img class="pokemon" src="${pokemon.species.spriteURL}" alt="Image du Pokémon ${pokemon.species.name}">

        <table>
            <tr>
                <th>Identifiant du Pokémon:</th>
                <td>${pokemon.id}</td>
            </tr>
            <tr>
                <th>Numéro dans le Pokédex:</th>
                <td>${pokemon.species.id}</td>
            </tr>
            <tr>
                <th>Nom du Pokémon:</th>
                <td>${pokemon.species.name}</td>
            </tr>
            <tr>
                <th>Surnom du Pokémon</th>
                <td>${pokemon.nickname}</td>
            </tr>
            <tr>
                <th>Niveau:</th>
                <td>${pokemon.level}</td>
            </tr>
            <tr>
                <th>Propriétaire du Pokémon:</th>
                <td><a href="/users/${pokemon.owner.id}">${pokemon.owner.identifier}</td>
            </tr>
        </table>
        <#if pokemon?size == 0>
            <p>Le Pokémon ${pokemon.id} n'existe pas encore !</p>
        </#if>

    </div>

    <#if connectedUser??>
    <hr>
    <h1>Pexer le ${pokemon.nickname} de ${pokemon.owner.identifier}</h1>
    <form method="POST" action="/pokemons/${pokemon.id}/levelup">
        <button type="submit">Pexer</button>
    </form>

    <#if pokemon.owner.id == connectedUser.id>
    <h1>Renommer son ${pokemon.nickname}</h1>
    <form method="POST" action="/pokemons/${pokemon.id}/rename">
        <input type="text" name="nickname" placeholder="Nouveau surnom">
        <button type="submit">Renommer</button>
    </form>

    <h1>Supprimer son ${pokemon.nickname}</h1>
    <form method="POST" action="/pokemons/${pokemon.id}/delete">
        <label>
            Souhaitez-vous vraiment supprimer votre ${pokemon.nickname} ? (Cette action est irréversible)
            <button type="submit">Supprimer</button>
        </label>
    </form>
   </#if>
    </#if>
    </#if>
</div>

</body>

</html>
