<#ftl encoding="utf-8">
<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">

<div class="content">
     <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

        <h1>Liste des échanges</h1>
        <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Pokémon expéditeur</th>
                <th>Expéditeur</th>
                <th>Pokémon destinataire</th>
                <th>Destinataire</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>
            <#list exchanges as exchange>
                <tr class="data-row">
                    <td><a href="/exchanges/${exchange.id}">${exchange.id}</a></td>
                    <td><a href="/pokemons/${exchange.pokemonExp.id}">${exchange.pokemonExp.nickname} de ${exchange.pokemonExp.owner.identifier}</a></td>
                    <td><a href="/users/${exchange.pokemonExp.owner.id}">${exchange.pokemonExp.owner.identifier}</td>
                    <td><a href="/pokemons/${exchange.pokemonDest.id}">${exchange.pokemonDest.nickname} de ${exchange.pokemonDest.owner.identifier}</a></td>
                    <td><a href="/users/${exchange.pokemonDest.owner.id}">${exchange.pokemonDest.owner.identifier}</td>
                    <td>${exchange.status}</td>
                </tr>
            </#list>
        </tbody>
    </table>

    <#if exchanges?size == 0>
        <p>Aucun échange de Pokémon n'a encore eu lieu. Mais cela ne saurait tarder !</p>
    </#if>

     <#if connectedUser??>
         <h1>Proposer un nouvel échange</h1>
         <form method="POST" action="/exchanges/start">
             <input type="number" name="exp" placeholder="Identifiant d'un de vos Pokémons">
             <input type="number" name="dest" placeholder="Identifiant d'un Pokémon d'un autre dresseur">
             <button type="submit">Lancer l'échange</button>
         </form>
     </#if>

    </#if>
</div>
</body>
</html>
