<#ftl encoding="utf-8">
<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">

<div class="content">
     <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

        <h1>Liste des échanges dont le dresseur ${dest.identifier} est destinataire</h1>
        <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Pokémon expéditeur</th>
                <th>Pokémon destinataire</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>
            <#list exchanges as exchange>
                <tr class="data-row">
                    <td><a href="/exchanges/${exchange.id}">${exchange.id}</a></td>
                    <td><a href="/pokemons/${exchange.pokemonExp.id}">${exchange.pokemonExp.nickname} de ${exchange.pokemonExp.owner.identifier}</a></td>
                    <td><a href="/pokemons/${exchange.pokemonDest.id}">${exchange.pokemonDest.nickname} de ${exchange.pokemonDest.owner.identifier}</a></td>
                    <td>${exchange.status}</td>
                </tr>
            </#list>
        </tbody>
    </table>

    <#if exchanges?size == 0>
        <p>${dest.identifier} n'a pas encore reçu d'échanges. Mais cela ne saurait tarder !</p>
    </#if>

    </#if>
</div>
</body>
</html>
