<#ftl encoding="utf-8">
<#include "/global/header.ftl">

<body xmlns="http://www.w3.org/1999/html">

<div class="content">
    <#if error??>
        <div class="error">Une erreur est survenue : ${error}</div>
    <#else>

    <h1>Échange numéro ${exchange.id} entre le Pokémon ${exchange.pokemonExp.nickname} et ${exchange.pokemonDest.nickname}</h1>

    <div class="informations">
        <img class="pokemon" src="${exchange.pokemonExp.species.spriteURL}" alt="Image du Pokémon ${exchange.pokemonExp.species.name}">

        <table>
            <tr>
                <th>ID de l'échange:</th>
                <td>${exchange.id}</td>
            </tr>
            <tr>
                <th>Pokémon expéditeur:</th>
                <td><a href="/pokemons/${exchange.pokemonExp.id}">${exchange.pokemonExp.nickname}</td>
            </tr>
            <tr>
                <th>Propriétaire du Pokémon expéditeur:</th>
                <td><a href="/users/${exchange.pokemonExp.owner.id}">${exchange.pokemonExp.owner.identifier}</td>
            </tr>
            <tr>
                <th>Pokémon destinataire:</th>
                <td><a href="/pokemons/${exchange.pokemonDest.id}">${exchange.pokemonDest.nickname}</td>
            </tr>
            <tr>
                <th>Propriétaire du Pokémon destinataire:</th>
                <td><a href="/users/${exchange.pokemonDest.owner.id}">${exchange.pokemonDest.owner.identifier}</td>
            </tr>
            <tr>
                <th>Statut de l'échange:</th>
                <td>${exchange.status}</td>
            </tr>
        </table>

        <img class="pokemon" src="${exchange.pokemonDest.species.spriteURL}" alt="Image du Pokémon ${exchange.pokemonDest.species.name}">

         <#if exchange?size == 0>
            <p>Aucun échange référencé par ${exchange.id} n'existe. Mais cela ne saurait tarder !</p>
        </#if>
    </div>

        <#if connectedUser?? && connectedUser.id == exchange.pokemonExp.owner.id && exchange.status == "PROPOSED">
            <form method="POST" action="/exchanges/${exchange.id}/cancel">
                <button type="submit">Annuler l'échange</button>
            </form>
        </#if>

        <#if connectedUser?? && connectedUser.id == exchange.pokemonDest.owner.id && exchange.status == "PROPOSED">
            <form method="POST" action="/exchanges/${exchange.id}/agree">
                <button type="submit">Accepter l'échange</button>
            </form>

            <form method="POST" action="/exchanges/${exchange.id}/disagree">
                <button type="submit">Refuser l'échange</button>
            </form>
        </#if>
    </#if>
</div>
</body>
</html>
