package com.uca.gui;

import com.uca.core.PokemonCore;
import com.uca.core.UserCore;
import com.uca.entity.UserEntity;
import com.uca.exceptions.ServiceException;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UserGUI {

    public static String getAllUsers(UserEntity connectedUser) throws IOException, TemplateException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("users", UserCore.getAll());
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "users/users.ftl");
    }

    public static String getUser(UserEntity connectedUser, int id) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("user", UserCore.getById(id));
            input.put("pokemons", PokemonCore.getAllByOwner(id));
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "users/user.ftl");
    }
}
